/*
 * Decompiled with CFR 0.152.
 */
package org.unitedid.yhsm.internal;

import org.unitedid.yhsm.internal.CommandHandler;
import org.unitedid.yhsm.internal.Defines;
import org.unitedid.yhsm.internal.DeviceHandler;
import org.unitedid.yhsm.internal.YubiHSMCommandFailedException;
import org.unitedid.yhsm.internal.YubiHSMErrorException;
import org.unitedid.yhsm.internal.YubiHSMInputException;
import org.unitedid.yhsm.utility.Utils;

public class AESECBCmd {
    private AESECBCmd() {
    }

    public static String encrypt(DeviceHandler deviceHandler, int keyHandle, String plaintext) throws YubiHSMInputException, YubiHSMErrorException, YubiHSMCommandFailedException {
        byte[] cmdBuffer = Utils.concatAllArrays(Utils.leIntToBA(keyHandle), new byte[][]{Utils.validateByteArray("plaintext", plaintext.getBytes(), 16, 0, 16)});
        byte[] result = CommandHandler.execute(deviceHandler, (byte)13, cmdBuffer, true);
        return AESECBCmd.parseResult(result, keyHandle, (byte)13, false);
    }

    public static String decrypt(DeviceHandler deviceHandler, int keyHandle, String cipherText) throws YubiHSMErrorException, YubiHSMInputException, YubiHSMCommandFailedException {
        byte[] cmdBuffer = Utils.concatAllArrays(Utils.leIntToBA(keyHandle), new byte[][]{Utils.validateByteArray("cipherText", Utils.hexToByteArray(cipherText), 0, 16, 0)});
        byte[] result = CommandHandler.execute(deviceHandler, (byte)14, cmdBuffer, true);
        return AESECBCmd.parseResult(result, keyHandle, (byte)14, true);
    }

    public static boolean compare(DeviceHandler deviceHandler, int keyHandle, String cipherText, String plaintext) throws YubiHSMInputException, YubiHSMErrorException, YubiHSMCommandFailedException {
        byte[] cipherTextBA = Utils.validateByteArray("cipherText", Utils.hexToByteArray(cipherText), 0, 16, 0);
        byte[] plaintextBA = Utils.validateByteArray("plaintext", plaintext.getBytes(), 16, 0, 16);
        byte[] keyHandleBA = Utils.leIntToBA(keyHandle);
        byte[] cmdBuffer = Utils.concatAllArrays(keyHandleBA, cipherTextBA, plaintextBA);
        byte[] result = CommandHandler.execute(deviceHandler, (byte)15, cmdBuffer, true);
        Utils.validateCmdResponseBA("keyHandle", Utils.rangeOfByteArray(result, 0, 4), keyHandleBA);
        if (result[4] == -128) {
            return true;
        }
        if (result[4] == -117) {
            return false;
        }
        throw new YubiHSMCommandFailedException("Command " + Defines.getCommandString((byte)15) + " failed: " + Defines.getCommandStatus(result[4]));
    }

    private static String parseResult(byte[] data, int keyHandle, byte command, boolean decrypt) throws YubiHSMErrorException, YubiHSMCommandFailedException {
        Utils.validateCmdResponseBA("keyHandle", Utils.rangeOfByteArray(data, 0, 4), Utils.leIntToBA(keyHandle));
        byte[] result = Utils.rangeOfByteArray(data, 4, 16);
        if (data[20] == -128) {
            return decrypt ? new String(result).trim() : Utils.byteArrayToHex(result);
        }
        throw new YubiHSMCommandFailedException("Command " + Defines.getCommandString(command) + " failed: " + Defines.getCommandStatus(data[20]));
    }
}

