/*
 * Decompiled with CFR 0.152.
 */
package org.unitedid.yhsm.internal;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.unitedid.yhsm.internal.Defines;
import org.unitedid.yhsm.internal.DeviceHandler;
import org.unitedid.yhsm.internal.YubiHSMErrorException;
import org.unitedid.yhsm.utility.Utils;

public class CommandHandler {
    private static final Logger log = LoggerFactory.getLogger(CommandHandler.class);

    private CommandHandler() {
    }

    protected static synchronized byte[] execute(DeviceHandler device, byte command, byte[] data, boolean readResponse) throws YubiHSMErrorException {
        byte[] cmdBuffer = command != 0 ? new byte[]{(byte)(data.length + 1 << 24 >> 24), command} : new byte[]{command};
        log.debug("CMD BUFFER: {}", (Object)Utils.byteArrayToHex(Utils.concatAllArrays(cmdBuffer, new byte[][]{data})));
        device.write(Utils.concatAllArrays(cmdBuffer, new byte[][]{data}));
        try {
            if (!readResponse) {
                Thread.sleep(10L);
                return null;
            }
            int sleptTime = 0;
            int timeout = 100;
            if (device.getTimeout() > 0.0f) {
                timeout = (int)(device.getTimeout() * 1000.0f);
            }
            log.debug("CommandHandler ({}) timeout set to: {} ms ", (Object)Defines.getCommandString(command), (Object)timeout);
            while (sleptTime <= timeout) {
                Thread.sleep(1L);
                ++sleptTime;
                if (device.available() <= 0) continue;
            }
            log.debug("CommandHandler slept for: {} ms", (Object)sleptTime);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return CommandHandler.readDevice(device, command);
    }

    private static byte[] readDevice(DeviceHandler device, byte command) throws YubiHSMErrorException {
        byte[] result = new byte[]{};
        if (device.available() > 0) {
            result = device.read(2);
        }
        if (result.length == 0) {
            CommandHandler.reset(device);
            throw new YubiHSMErrorException("No data received from the YubiHSM!");
        }
        if ((result[1] & 0xFFFFFF80) != 0) {
            log.debug("Got response from ({}) {}", (Object)result[1], (Object)Defines.getCommandString((byte)(result[1] - -128)));
        }
        if (result[1] == (command | 0xFFFFFF80)) {
            int len = result[0] - 1;
            return device.read(len);
        }
        CommandHandler.reset(device);
        throw new YubiHSMErrorException("YubiHSM responded to the wrong command. Expected " + Defines.getCommandString(command) + " but got " + Defines.getCommandString((byte)(result[1] - -128)));
    }

    public static void reset(DeviceHandler device) throws YubiHSMErrorException {
        log.debug("Sending reset command to device {}", (Object)device.getPortName());
        byte[] reset = new byte[95];
        for (int i = 0; i < 95; ++i) {
            reset[i] = 0;
        }
        CommandHandler.execute(device, (byte)0, reset, false);
    }
}

