/*
 * Decompiled with CFR 0.152.
 */
package org.unitedid.yhsm.internal;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.unitedid.yhsm.internal.DeviceHandler;
import org.unitedid.yhsm.internal.YubiHSMErrorException;

public class DeviceHandlerFactory {
    private static final Logger log = LoggerFactory.getLogger(DeviceHandlerFactory.class);
    private static Map<String, DeviceHandler> deviceHandlerFactoryMap = new HashMap<String, DeviceHandler>();

    private DeviceHandlerFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DeviceHandler get(String device) throws YubiHSMErrorException {
        Map<String, DeviceHandler> map = deviceHandlerFactoryMap;
        synchronized (map) {
            DeviceHandler deviceHandler = deviceHandlerFactoryMap.get(device);
            if (deviceHandler == null) {
                log.debug("Adding device {} to deviceHandlerFactory.", (Object)device);
                deviceHandler = new DeviceHandler(device);
                deviceHandlerFactoryMap.put(device, deviceHandler);
            } else {
                log.debug("Returning device {} from deviceHandlerFactory.", (Object)device);
            }
            return deviceHandler;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

