/*
 * Decompiled with CFR 0.152.
 */
package org.unitedid.yhsm.internal;

import org.unitedid.yhsm.internal.CommandHandler;
import org.unitedid.yhsm.internal.Defines;
import org.unitedid.yhsm.internal.DeviceHandler;
import org.unitedid.yhsm.internal.YubiHSMCommandFailedException;
import org.unitedid.yhsm.internal.YubiHSMErrorException;
import org.unitedid.yhsm.internal.YubiHSMInputException;
import org.unitedid.yhsm.utility.Utils;

public class KeyStoreDecryptCmd {
    private KeyStoreDecryptCmd() {
    }

    public static boolean execute(DeviceHandler device, String key) throws YubiHSMInputException, YubiHSMErrorException, YubiHSMCommandFailedException {
        byte[] keyBA = Utils.hexToByteArray(key);
        keyBA = Utils.validateByteArray("key", keyBA, 32, 0, 32);
        return KeyStoreDecryptCmd.parseResult(CommandHandler.execute(device, (byte)41, keyBA, true));
    }

    private static boolean parseResult(byte[] result) throws YubiHSMCommandFailedException {
        if (result[0] == -128) {
            return true;
        }
        if (result[0] == -117) {
            return false;
        }
        throw new YubiHSMCommandFailedException("Command " + Defines.getCommandString((byte)41) + " failed: " + Defines.getCommandStatus(result[0]));
    }
}

