/*
 * Decompiled with CFR 0.152.
 */
package org.unitedid.yhsm.internal;

import org.unitedid.yhsm.internal.CommandHandler;
import org.unitedid.yhsm.internal.Defines;
import org.unitedid.yhsm.internal.DeviceHandler;
import org.unitedid.yhsm.internal.Nonce;
import org.unitedid.yhsm.internal.YubiHSMCommandFailedException;
import org.unitedid.yhsm.internal.YubiHSMErrorException;
import org.unitedid.yhsm.utility.Utils;

public class NonceGetCmd {
    private NonceGetCmd() {
    }

    public static Nonce execute(DeviceHandler device, short increment) throws YubiHSMErrorException, YubiHSMCommandFailedException {
        byte[] result = CommandHandler.execute(device, (byte)34, Utils.leShortToByteArray(increment), true);
        return NonceGetCmd.parseResult(result);
    }

    private static Nonce parseResult(byte[] data) throws YubiHSMCommandFailedException {
        Nonce result = null;
        if (data[0] != -128) {
            throw new YubiHSMCommandFailedException("Command " + Defines.getCommandString((byte)34) + " failed: " + Defines.getCommandStatus(data[0]));
        }
        int vtile = Utils.leBAToBeInt(Utils.rangeOfByteArray(data, 1, 4));
        int powerUpCount = Utils.leBAToBeShort(Utils.rangeOfByteArray(data, 5, 2));
        int nonceInt = powerUpCount + vtile;
        String nonce = Utils.byteArrayToHex(Utils.rangeOfByteArray(data, 1, 6));
        result = new Nonce(vtile, powerUpCount, nonceInt, nonce);
        return result;
    }
}

