package org.unitils.cdi;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.Set;

import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.environment.se.WeldContainer;
import org.unitils.cdi.annotation.CdiInjection;
import org.unitils.core.Module;
import org.unitils.core.TestListener;
import org.unitils.util.AnnotationUtils;
import org.unitils.util.ReflectionUtils;


/**
 * CDI Module: This module tries to instantiate the fields with the {@link WeldContainer}.
 *
 * @author Willemijn Wouters
 *
 * @since 1.0.0
 *
 * @see <a href="http://weld.cdi-spec.org/documentation/">Weld</a>
 *
 * @see <a href="http://sourceforge.net/p/unitils-cdi/wiki/Home/">unitils-cdi documentation</a>
 *
 */
public class CdiModule implements Module {



    /**
     * @see org.unitils.core.Module#init(java.util.Properties)
     */
    @Override
    public void init(Properties configuration) {
        // do nothing at the moment
    }

    /**
     * @see org.unitils.core.Module#afterInit()
     */
    @Override
    public void afterInit() {
        // do nothing at the moment
    }

    protected void initialiseObjects(Object testObject) {
        Weld weld = new Weld();
        WeldContainer container = weld.initialize();

        Set<Field> fields = AnnotationUtils.getFieldsAnnotatedWith(testObject.getClass(), CdiInjection.class);
        for (Field field : fields) {
            Object obj = container.instance().select(field.getType()).get();
            ReflectionUtils.setFieldValue(testObject, field, obj);
        }

        weld.shutdown();
    }

    /**
     * @see org.unitils.core.Module#getTestListener()
     */
    @Override
    public TestListener getTestListener() {
        return new CdiTestlistener();
    }


    public class CdiTestlistener extends TestListener {
        /**
         * @see org.unitils.core.TestListener#beforeTestMethod(java.lang.Object, java.lang.reflect.Method)
         */
        @Override
        public void beforeTestMethod(Object testObject, Method testMethod) {
            initialiseObjects(testObject);
        }
    }
}
