package org.unitils.cdi;


import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;

import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.environment.se.WeldContainer;
import org.unitils.cdi.annotation.CdiInjection;
import org.unitils.core.Module;
import org.unitils.core.TestListener;
import org.unitils.util.AnnotationUtils;
import org.unitils.util.ReflectionUtils;

/**
 * CDI Module: This module tries to instantiate the fields with the {@link WeldContainer}.
 *
 * @author Willemijn Wouters, Boris Cnapelinckx
 *
 * @since 1.0.0
 *
 * @see <a href="http://weld.cdi-spec.org/documentation/">Weld</a>
 *
 * @see <a href="http://sourceforge.net/p/unitils-cdi/wiki/Home/">unitils-cdi documentation</a>
 *
 */
public class CdiModule implements Module {

    private Weld weld;



    /**
     * @see org.unitils.core.Module#init(java.util.Properties)
     */
    @Override
    public void init(Properties configuration) {
        // do nothing at the moment
    }

    /**
     * @see org.unitils.core.Module#afterInit()
     */
    @Override
    public void afterInit() {
        // do nothing at the moment
    }

    protected void initialiseObjects(Object testObject) {

        Set<?> fields = AnnotationUtils.getFieldsAnnotatedWith(testObject.getClass(), CdiInjection.class);
        Iterator<?> i$ = fields.iterator();
        WeldContainer container = null;
        weld = null;
        if (i$.hasNext()) {
            weld = new Weld();
            container = weld.initialize();

        }

        while(i$.hasNext()) {
            Field field = (Field)i$.next();
            Object obj = container.instance().select(field.getType(), getQualifiersFromField(field)).get();
            ReflectionUtils.setFieldValue(testObject, field, obj);
        }
    }

    protected void shutDown(Object testObject) {
        if (weld !=null) {
            weld.shutdown();
        }
    }

    protected Annotation[] getQualifiersFromField(Field field) {
        List<Annotation> annotations = new ArrayList<Annotation>();
        for (Annotation annotation : field.getAnnotations()) {
            if (!(annotation instanceof CdiInjection)) {
                annotations.add(annotation);
            }
        }
        Annotation[] arr = new Annotation[annotations.size()];
        return annotations.toArray(arr);
    }

    /**
     * @see org.unitils.core.Module#getTestListener()
     */
    @Override
    public TestListener getTestListener() {
        return new CdiTestlistener();
    }


    public class CdiTestlistener extends TestListener {
        @Override
        public void beforeTestMethod(Object testObject, Method testMethod) {
            initialiseObjects(testObject);
        }

        @Override
        public void afterTestMethod(Object testObject, Method testMethod, Throwable testThrowable) {
            shutDown(testObject);
        }
    }



    /**
     * @return the weld
     */
    public Weld getWeld() {
        return weld;
    }


    /**
     * @param weld the weld to set
     */
    public void setWeld(Weld weld) {
        this.weld = weld;
    }

}
