/*
 * Copyright 2008,  Unitils.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.unitils.compositetest;

/**
 * Interface describing the interaction of a test with its testParts.
 * 
 * @author Jef Verelst
 */
public interface CompositeTestDriver {

    /**
     * This method launches a given testpart. The testpart should already be
     * known (i.e. be above the method).
     * 
     * @param name the name of the testpart to be executed. Will throw an 
     * exception when the name is unknown.
     */
    void launchTestPart(String name);
}
