package org.unitils.compositetest.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

import org.unitils.compositetest.annotation.CompositeTestHandler;
import org.unitils.compositetest.annotation.TestPart;
import org.unitils.core.TestListener;
import org.unitils.inject.util.InjectionUtils;

/**
 *
 * @author Jef Verelst
 */
public class CompositeTestListener extends TestListener {
    private Map<Object,CompositeTestDriverImpl> driverMap = new HashMap<Object, CompositeTestDriverImpl>();

    @Override
    public void afterCreateTestObject(Object testObject) {
        super.afterCreateTestObject(testObject);        
        CompositeTestDriverImpl testDriver = new CompositeTestDriverImpl(testObject);
        driverMap.put(testObject, testDriver);        
        for(Field field : testObject.getClass().getDeclaredFields()) {
            if(field.getAnnotation(CompositeTestHandler.class) != null) {
                InjectionUtils.injectInto(testDriver, testObject, field.getName());
            }
        }
    }       

    /**
     * This method checks whether the <code>TestPart</code> annotation is present.
     * If it is, depending on the value specified in the annotation.
     * @return 
     */
    public boolean shouldInvokeTestMethod(Object testObject, Method testMethod) {
        TestPart annotation = testMethod.getAnnotation(TestPart.class);
        if(annotation != null) {
            return annotation.executeAsSingleTest();
        }
        return true;
    }
    
    

}
