/*
 * Copyright 2008,  Unitils.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.unitils.compositetest.annotation;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * This annotation is used to mark a method as reusable part of another test.
 * It can still be executed on its own, or you can mark it @Ignore if you 
 * want to use it as a part only.
 * 
 * @author Jef Verelst
 */
@Retention(RetentionPolicy.RUNTIME)
public @interface TestPart {
    
    
    /**
     * 
     * @return the name of the part. If left blank, the name of the method will
     * be used as testPart name.
     */
    String name() default "";
    
    /**
     * 
     * @return whether the part should be executed as individual test.
     */
    boolean executeAsSingleTest() default false;
}
