package org.unitils.compositetest.impl;

import java.lang.reflect.Method;

import org.unitils.compositetest.CompositeTestDriver;
import org.unitils.compositetest.annotation.TestPart;
import org.unitils.core.Unitils;

/**
 *
 * @author Jef Verelst
 */
public class CompositeTestDriverImpl implements CompositeTestDriver{
    
    private Object testObject;   

    public CompositeTestDriverImpl(Object testObject) {
        this.testObject = testObject;        
    }
    
    

    public void launchTestPart(String name) {
        for(Method method : this.testObject.getClass().getDeclaredMethods()) {
            if(method.getAnnotation(TestPart.class) != null) {
                TestPart part = (TestPart)method.getAnnotation(TestPart.class);
                if(name.equals(part.name()) || name.equals(method.getName())) {
                    System.out.println("Execute "+method);
                    Unitils.getInstance().getTestContext().getRunner().executeTestMethod(testObject, method);
                    return;
                }
            }
        }
    }

    

}
