/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.compositetest.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.unitils.compositetest.annotation.CompositeTestHandler;
import org.unitils.compositetest.annotation.TestPart;
import org.unitils.compositetest.impl.CompositeTestDriverImpl;
import org.unitils.core.TestListener;
import org.unitils.inject.util.InjectionUtils;

public class CompositeTestListener
extends TestListener {
    private Map<Object, CompositeTestDriverImpl> driverMap = new HashMap<Object, CompositeTestDriverImpl>();

    public void afterCreateTestObject(Object testObject) {
        super.afterCreateTestObject(testObject);
        CompositeTestDriverImpl testDriver = new CompositeTestDriverImpl(testObject);
        this.driverMap.put(testObject, testDriver);
        for (Field field : testObject.getClass().getDeclaredFields()) {
            if (field.getAnnotation(CompositeTestHandler.class) == null) continue;
            InjectionUtils.injectInto((Object)testDriver, (Object)testObject, (String)field.getName());
        }
    }

    public boolean shouldInvokeTestMethod(Object testObject, Method testMethod) {
        TestPart annotation = testMethod.getAnnotation(TestPart.class);
        if (annotation != null) {
            return annotation.executeAsSingleTest();
        }
        return true;
    }
}

