/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.ftp;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.Set;
import org.mockftpserver.fake.FakeFtpServer;
import org.mockftpserver.fake.UserAccount;
import org.mockftpserver.fake.filesystem.DirectoryEntry;
import org.mockftpserver.fake.filesystem.FileEntry;
import org.mockftpserver.fake.filesystem.FileSystem;
import org.mockftpserver.fake.filesystem.FileSystemEntry;
import org.mockftpserver.fake.filesystem.UnixFakeFileSystem;
import org.mockftpserver.fake.filesystem.WindowsFakeFileSystem;
import org.unitils.core.Module;
import org.unitils.core.TestListener;
import org.unitils.core.UnitilsException;
import org.unitils.ftp.annotations.TestFtpServer;
import org.unitils.thirdparty.org.apache.commons.io.FileUtils;
import org.unitils.util.AnnotationUtils;
import org.unitils.util.PropertyUtils;
import org.unitils.util.ReflectionUtils;

public class FtpModule
implements Module {
    private File defaultBaseFolder;
    private String os;
    private String encoding;
    private String ftpPort;
    private String userName;
    private String password;
    protected static final String PACKAGENAME = "org.unitils.ftp.";
    public static final String PROP_USERNAME = "org.unitils.ftp.username";
    public static final String PROP_BASEFOLDER = "org.unitils.ftp.baseFolder";
    public static final String PROP_PASSWORD = "org.unitils.ftp.password";
    public static final String PROP_ENCODING = "org.unitils.ftp.fileEncoding";
    public static final String PROP_PORT = "org.unitils.ftp.port";

    public void init(Properties configuration) {
        this.defaultBaseFolder = new File(configuration.getProperty(PROP_BASEFOLDER));
        this.os = configuration.getProperty("sun.desktop");
        this.userName = configuration.getProperty(PROP_USERNAME);
        this.password = configuration.getProperty(PROP_PASSWORD);
        this.encoding = PropertyUtils.getString((String)PROP_ENCODING, (String)"UTF-8", (Properties)configuration);
        this.ftpPort = PropertyUtils.getString((String)PROP_PORT, (String)"21", (Properties)configuration);
    }

    private FakeFtpServer initServer(Field field) throws IOException {
        FakeFtpServer server = new FakeFtpServer();
        UserAccount account = new UserAccount();
        account.setUsername(this.userName);
        account.setPassword(this.password);
        server.setServerControlPort(Integer.valueOf(this.ftpPort).intValue());
        server.addUserAccount(account);
        TestFtpServer annotation = field.getAnnotation(TestFtpServer.class);
        File baseFolder = this.defaultBaseFolder;
        if (!annotation.baseFolder().isEmpty()) {
            baseFolder = new File(annotation.baseFolder());
        }
        Object fileSystem = null;
        fileSystem = "WINDOWS".equalsIgnoreCase(this.os) ? new WindowsFakeFileSystem() : new UnixFakeFileSystem();
        this.addToFileSystem((FileSystem)fileSystem, baseFolder);
        server.setFileSystem((FileSystem)fileSystem);
        account.setHomeDirectory(baseFolder.getAbsolutePath());
        server.start();
        return server;
    }

    private void addToFileSystem(FileSystem fileSystem, File file) throws IOException {
        DirectoryEntry entry;
        if (file.isFile()) {
            entry = new FileEntry(file.getAbsolutePath(), FileUtils.readFileToString((File)file, (String)this.encoding));
            fileSystem.add((FileSystemEntry)entry);
        }
        if (file.isDirectory()) {
            entry = new DirectoryEntry(file.getAbsolutePath());
            fileSystem.add((FileSystemEntry)entry);
            for (File child : file.listFiles()) {
                this.addToFileSystem(fileSystem, child);
            }
        }
    }

    public void afterInit() {
    }

    public TestListener getTestListener() {
        return new FtpTestListener();
    }

    private class FtpTestListener
    extends TestListener {
        private FakeFtpServer server;

        private FtpTestListener() {
        }

        public void beforeTestSetUp(Object testObject, Method testMethod) {
            try {
                Field field = this.getServerField(testObject);
                if (field != null) {
                    this.server = FtpModule.this.initServer(field);
                    ReflectionUtils.setFieldValue((Object)testObject, (Field)field, (Object)this.server);
                }
            }
            catch (IOException e) {
                throw new UnitilsException("Initializing FtpModule failed ", (Throwable)e);
            }
        }

        private Field getServerField(Object testObject) {
            Set fieldSet = AnnotationUtils.getFieldsAnnotatedWith(testObject.getClass(), TestFtpServer.class);
            if (fieldSet.isEmpty()) {
                return null;
            }
            Field field = (Field)fieldSet.iterator().next();
            return field;
        }

        public void afterTestMethod(Object testObject, Method testMethod, Throwable testThrowable) {
            if (this.server != null) {
                this.server.stop();
            }
        }
    }
}

