package org.unitils.jbehave;

import static org.jbehave.core.reporters.Format.CONSOLE;
import static org.jbehave.core.reporters.Format.HTML;
import static org.jbehave.core.reporters.Format.TXT;
import static org.jbehave.core.reporters.Format.XML;

import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.configuration.MostUsefulConfiguration;
import org.jbehave.core.reporters.StoryReporterBuilder;
import org.unitils.core.Factory;

/**
 * This class creates the {@link Configuration} for JBehave.
 * 
 * @author Willemijn Wouters
 * 
 * @since 1.0.0
 * 
 */
public class JBehaveMostUseFulConfiguration implements Factory<Configuration> {

    /**
     * @see org.unitils.core.Factory#create()
     */
    @Override
    public Configuration create() {
        MostUsefulConfiguration config = new MostUsefulConfiguration ();
        StoryReporterBuilder storyReporterBuilder = new StoryReporterBuilder()
        .withDefaultFormats()
        .withFormats(CONSOLE, TXT, HTML, XML);
        return config.useStoryReporterBuilder(storyReporterBuilder);
        
    }

}
