package org.unitils.jbehave;

import java.util.List;

import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.junit.JUnitStories;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.junit.runner.RunWith;
import org.unitils.jbehave.core.UnitilsInstanceStepsFactory;

import de.codecentric.jbehave.junit.monitoring.JUnitReportingRunner;


/**
 * Extended {@link JUnitStories} with some specific Unitils configuration.
 * 
 * @author Willemijn Wouters
 * 
 * @since 1.0.0
 * 
 */
@RunWith(JUnitReportingRunner.class)
public abstract class UnitilsJUnitStories extends JUnitStories {
    
    /**
     * @see org.jbehave.core.ConfigurableEmbedder#stepsFactory()
     */
    @Override
    public InjectableStepsFactory stepsFactory() {
        return new UnitilsInstanceStepsFactory(configuration(), getSteps());
    }
    
    
    public abstract List<? extends Object> getSteps();
    
    /**
     * @see org.jbehave.core.ConfigurableEmbedder#configuration()
     */
    @Override
    public Configuration configuration() {
        return new JBehaveMostUseFulConfiguration().create();
    }
}
