package org.unitils.jbehave.core;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.parsers.StepPatternParser;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.jbehave.core.steps.ParameterControls;
import org.jbehave.core.steps.ParameterConverters;
import org.jbehave.core.steps.StepCandidate;
import org.jbehave.core.steps.StepMonitor;
import org.jbehave.core.steps.StepType;
import org.unitils.jbehave.core.stepcreator.UnitilsStepCreator;
import org.unitils.util.ReflectionUtils;


/**
 * This class creates a {@link StepCandidate} with all the Unitils classes.
 * 
 * @author Willemijn Wouters
 * 
 * @since 1.0.0
 * 
 */
public class UnitilsStepCandidate extends StepCandidate {

    /**
     * @param patternAsString
     * @param priority
     * @param stepType
     * @param method
     * @param stepsType
     * @param stepsFactory
     * @param keywords
     * @param stepPatternParser
     * @param parameterConverters
     * @param parameterControls
     */
    public UnitilsStepCandidate(String patternAsString, int priority, StepType stepType, Method method, Class<?> stepsType, InjectableStepsFactory stepsFactory, Keywords keywords, StepPatternParser stepPatternParser, ParameterConverters parameterConverters, ParameterControls parameterControls) {
        super(patternAsString, priority, stepType, method, stepsType, stepsFactory, keywords, stepPatternParser, parameterConverters, parameterControls);
    
        Field stepCreatorField = ReflectionUtils.getFieldWithName(StepCandidate.class, "stepCreator", false);
        Field stepMonitorField = ReflectionUtils.getFieldWithName(StepCandidate.class, "stepMonitor", false);
        StepMonitor stepMonitor = ReflectionUtils.getFieldValue(this, stepMonitorField);
        ReflectionUtils.setFieldValue(this, stepCreatorField, new UnitilsStepCreator(stepsType, stepsFactory, parameterConverters, parameterControls, stepPatternParser.parseStep(stepType, patternAsString), stepMonitor));
    }

}
