package org.unitils.jbehave.core.reporters;

import org.jbehave.core.reporters.FilePrintStreamFactory;
import org.jbehave.core.reporters.Format;
import org.jbehave.core.reporters.StoryReporter;
import org.jbehave.core.reporters.StoryReporterBuilder;

/**
 * Unitils custom JBehave Formats for.
 *
 * @author Suzan Rogge
 * @since 31/10/2014
 */
public interface UnitilsFormats {

    public static final Format TESTLINK = new Format("TESTLINK") {

        private TestLinkJBehaveReporter testLinkReporter = new TestLinkJBehaveReporter();

        @Override
        public StoryReporter createStoryReporter(FilePrintStreamFactory factory, StoryReporterBuilder storyReporterBuilder) {
            factory.useConfiguration(storyReporterBuilder.fileConfiguration("testlink"));
            return testLinkReporter;
        }
    };
}
