package org.unitils.jbehave.core.steps;

import java.lang.reflect.Method;

import org.jbehave.core.annotations.AfterScenario.Outcome;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.jbehave.core.steps.StepCollector.Stage;
import org.jbehave.core.steps.StepCreator;
import org.unitils.core.TestListener;
import org.unitils.util.ReflectionUtils;


/**
 * step for {@link TestListener#beforeTestSetUp(Object, Method)}.
 * 
 * @author Willemijn Wouters
 * 
 * @since 1.0.0
 * 
 */
public class UnitilsBeforeTestSetUpStep extends AbstractUnitilsSteps implements IUnitilsStep {
    /**
     * @param testMethod
     * @param stage
     * @param outcome
     * @param stepCreator
     * @param injectableStepsFactory
     * @param type
     */
    public UnitilsBeforeTestSetUpStep(Method testMethod, Stage stage, Outcome outcome, StepCreator stepCreator, InjectableStepsFactory injectableStepsFactory, Class<?> type) {
        super(stage, ReflectionUtils.getMethod(TestListener.class, "beforeTestSetUp", false, Object.class, Method.class), testMethod, outcome, stepCreator, injectableStepsFactory, type);
    }

    /**
     * @see org.unitils.jbehave.core.steps.AbstractUnitilsSteps#getParametersMethod()
     */
    @Override
    protected Object[] getParametersMethod() {
        return new Object[]{getTestObject(), getTestMethod()};
    }

}
