package org.unitils.jbehave.modules;

import org.unitils.core.Unitils;
import org.unitils.testlink.TestLinkModule;
import org.unitils.util.PropertyUtils;

import java.util.Properties;

/**
 * @author Suzan Rogge
 * @since 31/10/2014
 */
public class JBehaveTestLinkModule extends TestLinkModule {

    private boolean enabled;
    private String caseId;
    private String suiteId;

    public JBehaveTestLinkModule() {
        Properties properties = Unitils.getInstance().getConfiguration();
        enabled = PropertyUtils.getBoolean("unitils.module.testlink.enabled", false, properties);
        if (enabled) {
            super.init(properties);
        }
    }

    public void updateTestCase(Throwable failure) {
        super.updateTestCase(caseId, suiteId, failure);
    }

    public void setCaseId(String caseId) {
        this.caseId = caseId;
    }

    public void setSuiteId(String suiteId) {
        this.suiteId = suiteId;
    }

    public boolean hasCaseId() {
        return caseId != null;
    }

    public void reset() {
        caseId = null;
        suiteId = null;
    }

    public boolean isEnabled() {
        return enabled;
    }
}
