/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.jbehave.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jbehave.core.annotations.AfterScenario;
import org.jbehave.core.annotations.AfterStory;
import org.jbehave.core.annotations.Alias;
import org.jbehave.core.annotations.Aliases;
import org.jbehave.core.annotations.BeforeScenario;
import org.jbehave.core.annotations.BeforeStory;
import org.jbehave.core.annotations.Composite;
import org.jbehave.core.annotations.Given;
import org.jbehave.core.annotations.ScenarioType;
import org.jbehave.core.annotations.Then;
import org.jbehave.core.annotations.When;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.steps.BeforeOrAfterStep;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.jbehave.core.steps.PatternVariantBuilder;
import org.jbehave.core.steps.StepCandidate;
import org.jbehave.core.steps.StepCollector;
import org.jbehave.core.steps.StepCreator;
import org.jbehave.core.steps.StepType;
import org.jbehave.core.steps.Steps;
import org.unitils.jbehave.core.UnitilsStepCandidate;
import org.unitils.jbehave.core.stepcreator.UnitilsStepCreator;
import org.unitils.jbehave.core.steps.BasicUnitilsSteps;
import org.unitils.jbehave.core.steps.UnitilsStepsFactory;
import org.unitils.util.AnnotationUtils;
import org.unitils.util.ReflectionUtils;

public class UnitilsSteps
extends Steps {
    public UnitilsSteps(Configuration configuration, Class<?> type, InjectableStepsFactory stepsFactory) {
        super(configuration, type, stepsFactory);
    }

    public List<BeforeOrAfterStep> listBeforeOrAfterScenario(ScenarioType type) {
        ArrayList<BeforeOrAfterStep> steps = new ArrayList<BeforeOrAfterStep>();
        StepCreator stepCreator = this.createStepCreator();
        InjectableStepsFactory stepsFactory = this.getStepsFactory();
        steps.addAll(UnitilsStepsFactory.createBeforeTestClassStep(stepCreator, stepsFactory, this.type()));
        steps.addAll(UnitilsStepsFactory.createAfterCreateTestObject(stepCreator, stepsFactory, this.type()));
        steps.addAll(UnitilsStepsFactory.createBeforeTestSetUp(stepCreator, stepsFactory, this.type()));
        steps.addAll(this.scenarioStepsHaving(type, StepCollector.Stage.BEFORE, BeforeScenario.class, new AfterScenario.Outcome[0]));
        steps.addAll(UnitilsStepsFactory.createBeforeTestMethod(stepCreator, stepsFactory, this.type()));
        steps.addAll(UnitilsStepsFactory.createAfterTestMethod(stepCreator, stepsFactory, this.type()));
        steps.addAll(this.scenarioStepsHaving(type, StepCollector.Stage.AFTER, AfterScenario.class, AfterScenario.Outcome.ANY, AfterScenario.Outcome.SUCCESS, AfterScenario.Outcome.FAILURE));
        steps.addAll(UnitilsStepsFactory.createAfterTestTearDown(stepCreator, stepsFactory, this.type()));
        return Collections.unmodifiableList(steps);
    }

    public List<BeforeOrAfterStep> listBeforeOrAfterStory(boolean givenStory) {
        ArrayList<BeforeOrAfterStep> steps = new ArrayList<BeforeOrAfterStep>();
        steps.addAll(this.stepsHaving(StepCollector.Stage.BEFORE, BeforeStory.class, givenStory));
        steps.addAll(this.stepsHaving(StepCollector.Stage.AFTER, AfterStory.class, givenStory));
        return Collections.unmodifiableList(steps);
    }

    protected List<BeforeOrAfterStep> scenarioStepsHaving(ScenarioType type, StepCollector.Stage stage, Class<? extends Annotation> annotationClass, AfterScenario.Outcome ... outcomes) {
        ArrayList<BeforeOrAfterStep> steps = new ArrayList<BeforeOrAfterStep>();
        for (Method method : AnnotationUtils.getMethodsAnnotatedWith((Class)this.type(), annotationClass)) {
            ScenarioType scenarioType = this.scenarioType(method, annotationClass);
            if (type != scenarioType) continue;
            if (stage == StepCollector.Stage.BEFORE) {
                steps.add(this.createBeforeOrAfterStep(stage, method));
            }
            if (stage != StepCollector.Stage.AFTER) continue;
            AfterScenario.Outcome scenarioOutcome = this.scenarioOutcome(method, annotationClass);
            for (AfterScenario.Outcome outcome : outcomes) {
                if (!outcome.equals((Object)scenarioOutcome)) continue;
                steps.add(this.createBeforeOrAfterStep(stage, method, outcome));
            }
        }
        return steps;
    }

    protected List<BeforeOrAfterStep> stepsHaving(StepCollector.Stage stage, Class<? extends Annotation> annotationClass, boolean givenStory) {
        ArrayList<BeforeOrAfterStep> steps = new ArrayList<BeforeOrAfterStep>();
        for (Method method : AnnotationUtils.getMethodsAnnotatedWith((Class)this.type(), annotationClass)) {
            if (!this.runnableStoryStep(method.getAnnotation(annotationClass), givenStory)) continue;
            steps.add(this.createBeforeOrAfterStep(stage, method));
        }
        return steps;
    }

    protected boolean runnableStoryStep(Annotation annotation, boolean givenStory) {
        boolean uponGivenStory = this.uponGivenStory(annotation);
        return uponGivenStory == givenStory;
    }

    protected boolean uponGivenStory(Annotation annotation) {
        if (annotation instanceof BeforeStory) {
            return ((BeforeStory)annotation).uponGivenStory();
        }
        if (annotation instanceof AfterStory) {
            return ((AfterStory)annotation).uponGivenStory();
        }
        return false;
    }

    protected ScenarioType scenarioType(Method method, Class<? extends Annotation> annotationClass) {
        if (annotationClass.isAssignableFrom(BeforeScenario.class)) {
            return ((BeforeScenario)method.getAnnotation(annotationClass)).uponType();
        }
        if (annotationClass.isAssignableFrom(AfterScenario.class)) {
            return ((AfterScenario)method.getAnnotation(annotationClass)).uponType();
        }
        return ScenarioType.NORMAL;
    }

    protected BeforeOrAfterStep createBeforeOrAfterStep(StepCollector.Stage stage, Method method) {
        return this.createBeforeOrAfterStep(stage, method, AfterScenario.Outcome.ANY);
    }

    protected BeforeOrAfterStep createBeforeOrAfterStep(StepCollector.Stage stage, Method method, AfterScenario.Outcome outcome) {
        return new BasicUnitilsSteps(stage, method, outcome, this.createStepCreator());
    }

    protected AfterScenario.Outcome scenarioOutcome(Method method, Class<? extends Annotation> annotationClass) {
        if (annotationClass.isAssignableFrom(AfterScenario.class)) {
            return ((AfterScenario)method.getAnnotation(annotationClass)).uponOutcome();
        }
        return AfterScenario.Outcome.ANY;
    }

    protected StepCandidate createCandidate(Method method, StepType stepType, String stepPatternAsString, int priority, Configuration configuration) {
        return new UnitilsStepCandidate(stepPatternAsString, priority, stepType, method, this.type(), this.getStepsFactory(), configuration.keywords(), configuration.stepPatternParser(), configuration.parameterConverters(), configuration.parameterControls());
    }

    protected void addCandidate(List<StepCandidate> candidates, Method method, StepType stepType, String stepPatternAsString, int priority) {
        this.checkForDuplicateCandidates(candidates, stepType, stepPatternAsString);
        StepCandidate candidate = this.createCandidate(method, stepType, stepPatternAsString, priority, this.configuration());
        candidate.useStepMonitor(this.configuration().stepMonitor());
        candidate.useParanamer(this.configuration().paranamer());
        candidate.doDryRun(this.configuration().storyControls().dryRun());
        if (method.isAnnotationPresent(Composite.class)) {
            candidate.composedOf(method.getAnnotation(Composite.class).steps());
        }
        candidates.add(candidate);
    }

    protected void addCandidatesFromVariants(List<StepCandidate> candidates, Method method, StepType stepType, String value, int priority) {
        PatternVariantBuilder b = new PatternVariantBuilder(value);
        for (String variant : b.allVariants()) {
            this.addCandidate(candidates, method, stepType, variant, priority);
        }
    }

    protected void addCandidatesFromAliases(List<StepCandidate> candidates, Method method, StepType stepType, int priority) {
        if (method.isAnnotationPresent(Aliases.class)) {
            String[] aliases;
            for (String alias : aliases = method.getAnnotation(Aliases.class).values()) {
                this.addCandidatesFromVariants(candidates, method, stepType, alias, priority);
            }
        }
        if (method.isAnnotationPresent(Alias.class)) {
            String alias = method.getAnnotation(Alias.class).value();
            this.addCandidatesFromVariants(candidates, method, stepType, alias, priority);
        }
    }

    protected void checkForDuplicateCandidates(List<StepCandidate> candidates, StepType stepType, String patternAsString) {
        for (StepCandidate candidate : candidates) {
            if (candidate.getStepType() != stepType || !candidate.getPatternAsString().equals(patternAsString)) continue;
            throw new Steps.DuplicateCandidateFound(stepType, patternAsString);
        }
    }

    public List<StepCandidate> listCandidates() {
        ArrayList<StepCandidate> candidates = new ArrayList<StepCandidate>();
        for (Method method : Arrays.asList(this.type().getMethods())) {
            int priority;
            String value;
            Given annotation;
            if (method.isAnnotationPresent(Given.class)) {
                annotation = method.getAnnotation(Given.class);
                value = annotation.value();
                priority = annotation.priority();
                this.addCandidatesFromVariants(candidates, method, StepType.GIVEN, value, priority);
                this.addCandidatesFromAliases(candidates, method, StepType.GIVEN, priority);
            }
            if (method.isAnnotationPresent(When.class)) {
                annotation = method.getAnnotation(When.class);
                value = annotation.value();
                priority = annotation.priority();
                this.addCandidatesFromVariants(candidates, method, StepType.WHEN, value, priority);
                this.addCandidatesFromAliases(candidates, method, StepType.WHEN, priority);
            }
            if (!method.isAnnotationPresent(Then.class)) continue;
            annotation = method.getAnnotation(Then.class);
            value = annotation.value();
            priority = annotation.priority();
            this.addCandidatesFromVariants(candidates, method, StepType.THEN, value, priority);
            this.addCandidatesFromAliases(candidates, method, StepType.THEN, priority);
        }
        return candidates;
    }

    public StepCreator createStepCreator() {
        return new UnitilsStepCreator(this.type(), this.getStepsFactory(), this.configuration().parameterConverters(), this.configuration().parameterControls(), null, this.configuration().stepMonitor());
    }

    public InjectableStepsFactory getStepsFactory() {
        Field fieldStepsFactory = ReflectionUtils.getFieldWithName(Steps.class, (String)"stepsFactory", (boolean)false);
        return (InjectableStepsFactory)ReflectionUtils.getFieldValue((Object)((Object)this), (Field)fieldStepsFactory);
    }
}

