/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.jbehave.modules;

import java.lang.reflect.Field;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.unitils.selenium.BrowserChoice;
import org.unitils.selenium.WebDriverFactory;
import org.unitils.selenium.WebDriverModule;
import org.unitils.selenium.annotation.TestWebDriver;
import org.unitils.selenium.annotation.WebPage;
import org.unitils.util.AnnotationUtils;
import org.unitils.util.ReflectionUtils;

public class JBehaveWebdriverModule
extends WebDriverModule {
    private static final Log LOGGER = LogFactory.getLog(JBehaveWebdriverModule.class);
    private WebDriver webdriver;

    public void initWebDriver(Object testObject) {
        Set fields = AnnotationUtils.getFieldsAnnotatedWith(testObject.getClass(), TestWebDriver.class);
        if (!fields.isEmpty()) {
            if (this.webdriver == null) {
                this.webdriver = this.createWebdriver();
            }
            for (Field field : fields) {
                ReflectionUtils.setFieldValue((Object)testObject, (Field)field, (Object)this.webdriver);
            }
        }
    }

    public void initElements(Object testObject) {
        Set fields = AnnotationUtils.getFieldsAnnotatedWith(testObject.getClass(), WebPage.class);
        Set webdrivers = AnnotationUtils.getFieldsAnnotatedWith(testObject.getClass(), TestWebDriver.class);
        if (webdrivers.size() > 0) {
            WebDriver webdriver = (WebDriver)ReflectionUtils.getFieldValue((Object)testObject, (Field)((Field)webdrivers.iterator().next()));
            for (Field field : fields) {
                if (webdriver == null) continue;
                ReflectionUtils.setFieldValue((Object)testObject, (Field)field, (Object)this.getElement(webdriver, field.getType()));
            }
        }
    }

    protected void killWebDriver(Object testObject) {
        if (this.webdriver != null) {
            LOGGER.debug((Object)("closing a driver that is on page : " + this.webdriver.getCurrentUrl()));
            this.webdriver.close();
            this.webdriver.quit();
            this.nastyDoubleCheck(this.webdriver);
            this.nastyDoubleCheck(this.webdriver);
            this.webdriver = null;
        }
    }

    protected void nastyDoubleCheck(WebDriver driver) {
        try {
            Thread.sleep(500L);
            driver.getTitle();
            driver.close();
            driver.quit();
        }
        catch (WebDriverException e) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected WebDriver createWebdriver() {
        BrowserChoice browserChoice = this.getBrowserChoice();
        String downloadPath2 = this.getDownloadPath();
        String fileType2 = this.getFileType();
        WebDriver driver = StringUtils.isEmpty((String)this.getProxyUrl()) ? WebDriverFactory.createDriver((BrowserChoice)browserChoice, (String)JBehaveWebdriverModule.getAbsoluteDownloadPath((String)downloadPath2), (String)fileType2) : WebDriverFactory.createDriver((BrowserChoice)browserChoice, (String)this.getProxyUrl(), (String)JBehaveWebdriverModule.getAbsoluteDownloadPath((String)downloadPath2), (String)fileType2);
        driver.manage().deleteAllCookies();
        return driver;
    }

    protected String getProxyUrl() {
        return (String)this.getFieldValue("proxyUrl");
    }

    protected String getDownloadPath() {
        return (String)this.getFieldValue("downloadPath");
    }

    protected BrowserChoice getBrowserChoice() {
        return (BrowserChoice)this.getFieldValue("browserChoice");
    }

    public Object getFieldValue(String nameField) {
        Field field = ReflectionUtils.getFieldWithName(WebDriverModule.class, (String)nameField, (boolean)false);
        return ReflectionUtils.getFieldValue((Object)((Object)this), (Field)field);
    }

    public String getFileType() {
        return (String)this.getFieldValue("fileType");
    }

    protected WebDriver getWebdriver() {
        return this.webdriver;
    }
}

