/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.jbehave.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jbehave.core.annotations.AfterScenario;
import org.jbehave.core.annotations.BeforeScenario;
import org.jbehave.core.annotations.ScenarioType;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.steps.BeforeOrAfterStep;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.jbehave.core.steps.StepCandidate;
import org.jbehave.core.steps.StepCollector;
import org.jbehave.core.steps.StepCreator;
import org.jbehave.core.steps.StepType;
import org.jbehave.core.steps.Steps;
import org.unitils.jbehave.core.UnitilsStepCandidate;
import org.unitils.jbehave.core.stepcreator.UnitilsStepCreator;
import org.unitils.jbehave.core.steps.BasicUnitilsSteps;
import org.unitils.jbehave.core.steps.UnitilsStepsFactory;
import org.unitils.util.AnnotationUtils;
import org.unitils.util.ReflectionUtils;

public class UnitilsSteps
extends Steps {
    public UnitilsSteps(Configuration configuration, Class<?> type, InjectableStepsFactory stepsFactory) {
        super(configuration, type, stepsFactory);
    }

    public List<BeforeOrAfterStep> listBeforeOrAfterScenario(ScenarioType type) {
        ArrayList<BeforeOrAfterStep> steps = new ArrayList<BeforeOrAfterStep>();
        StepCreator stepCreator = this.createStepCreator();
        InjectableStepsFactory stepsFactory = this.getStepsFactory();
        steps.addAll(UnitilsStepsFactory.createBeforeTestClassStep(stepCreator, stepsFactory, this.type()));
        steps.addAll(UnitilsStepsFactory.createAfterCreateTestObject(stepCreator, stepsFactory, this.type()));
        steps.addAll(UnitilsStepsFactory.createBeforeTestSetUp(stepCreator, stepsFactory, this.type()));
        steps.addAll(this.scenarioStepsHaving(type, StepCollector.Stage.BEFORE, BeforeScenario.class, new AfterScenario.Outcome[0]));
        steps.addAll(UnitilsStepsFactory.createBeforeTestMethod(stepCreator, stepsFactory, this.type()));
        steps.addAll(UnitilsStepsFactory.createAfterTestMethod(stepCreator, stepsFactory, this.type()));
        steps.addAll(this.scenarioStepsHaving(type, StepCollector.Stage.AFTER, AfterScenario.class, AfterScenario.Outcome.ANY, AfterScenario.Outcome.SUCCESS, AfterScenario.Outcome.FAILURE));
        steps.addAll(UnitilsStepsFactory.createAfterTestTearDown(stepCreator, stepsFactory, this.type()));
        return Collections.unmodifiableList(steps);
    }

    protected List<BeforeOrAfterStep> scenarioStepsHaving(ScenarioType type, StepCollector.Stage stage, Class<? extends Annotation> annotationClass, AfterScenario.Outcome ... outcomes) {
        ArrayList<BeforeOrAfterStep> steps = new ArrayList<BeforeOrAfterStep>();
        for (Method method : AnnotationUtils.getMethodsAnnotatedWith((Class)this.type(), annotationClass)) {
            ScenarioType scenarioType = this.scenarioType(method, annotationClass);
            if (type != scenarioType) continue;
            if (stage == StepCollector.Stage.BEFORE) {
                steps.add(this.createBeforeOrAfterStep(stage, method));
            }
            if (stage != StepCollector.Stage.AFTER) continue;
            AfterScenario.Outcome scenarioOutcome = this.scenarioOutcome(method, annotationClass);
            for (AfterScenario.Outcome outcome : outcomes) {
                if (!outcome.equals((Object)scenarioOutcome)) continue;
                steps.add(this.createBeforeOrAfterStep(stage, method, outcome));
            }
        }
        return steps;
    }

    protected ScenarioType scenarioType(Method method, Class<? extends Annotation> annotationClass) {
        if (annotationClass.isAssignableFrom(BeforeScenario.class)) {
            return ((BeforeScenario)method.getAnnotation(annotationClass)).uponType();
        }
        if (annotationClass.isAssignableFrom(AfterScenario.class)) {
            return ((AfterScenario)method.getAnnotation(annotationClass)).uponType();
        }
        return ScenarioType.NORMAL;
    }

    protected BeforeOrAfterStep createBeforeOrAfterStep(StepCollector.Stage stage, Method method) {
        return this.createBeforeOrAfterStep(stage, method, AfterScenario.Outcome.ANY);
    }

    protected BeforeOrAfterStep createBeforeOrAfterStep(StepCollector.Stage stage, Method method, AfterScenario.Outcome outcome) {
        return new BasicUnitilsSteps(stage, method, outcome, this.createStepCreator());
    }

    protected AfterScenario.Outcome scenarioOutcome(Method method, Class<? extends Annotation> annotationClass) {
        if (annotationClass.isAssignableFrom(AfterScenario.class)) {
            return ((AfterScenario)method.getAnnotation(annotationClass)).uponOutcome();
        }
        return AfterScenario.Outcome.ANY;
    }

    protected StepCandidate createCandidate(Method method, StepType stepType, String stepPatternAsString, int priority, Configuration configuration) {
        return new UnitilsStepCandidate(stepPatternAsString, priority, stepType, method, this.type(), this.getStepsFactory(), configuration.keywords(), configuration.stepPatternParser(), configuration.parameterConverters(), configuration.parameterControls());
    }

    public StepCreator createStepCreator() {
        return new UnitilsStepCreator(this.type(), this.getStepsFactory(), this.configuration().parameterConverters(), this.configuration().parameterControls(), null, this.configuration().stepMonitor());
    }

    public InjectableStepsFactory getStepsFactory() {
        Field fieldStepsFactory = ReflectionUtils.getFieldWithName(Steps.class, (String)"stepsFactory", (boolean)false);
        return (InjectableStepsFactory)ReflectionUtils.getFieldValue((Object)((Object)this), (Field)fieldStepsFactory);
    }
}

