/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.jbehave.core.parsers;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbehave.core.annotations.AfterScenario;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.i18n.LocalizedKeywords;
import org.jbehave.core.model.Description;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.ExamplesTableFactory;
import org.jbehave.core.model.GivenStories;
import org.jbehave.core.model.Lifecycle;
import org.jbehave.core.model.Meta;
import org.jbehave.core.model.Narrative;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.model.Story;
import org.jbehave.core.parsers.RegexStoryParser;

public class RegexStoryParserExtended
extends RegexStoryParser {
    protected static final Log LOGGER = LogFactory.getLog(RegexStoryParserExtended.class);
    private static final String NONE = "";
    private Keywords keywords;
    private ExamplesTableFactory tableFactory;

    public RegexStoryParserExtended() {
        this((Keywords)new LocalizedKeywords());
    }

    public RegexStoryParserExtended(ExamplesTableFactory tableFactory) {
        this((Keywords)new LocalizedKeywords(), tableFactory);
    }

    public RegexStoryParserExtended(Keywords keywords) {
        this(keywords, new ExamplesTableFactory());
    }

    public RegexStoryParserExtended(Keywords keywords, ExamplesTableFactory tableFactory) {
        super(keywords, tableFactory);
        this.keywords = keywords;
        this.tableFactory = tableFactory;
    }

    public Story parseStory(String storyAsText, String storyPath) {
        Description description = this.parseDescriptionFrom(storyAsText);
        Meta meta = this.parseStoryMetaFrom(storyAsText);
        Narrative narrative = this.parseNarrativeFrom(storyAsText);
        GivenStories givenStories = this.parseGivenStories(storyAsText);
        Lifecycle lifecycle = this.parseLifecycle(storyAsText);
        List<Scenario> scenarios = this.parseScenariosFrom(storyAsText);
        Story story = new Story(storyPath, description, meta, narrative, givenStories, lifecycle, scenarios);
        if (storyPath != null) {
            story.namedAs(new File(storyPath).getName());
        }
        return story;
    }

    protected Description parseDescriptionFrom(String storyAsText) {
        Matcher findingDescription = this.patternToPullDescriptionIntoGroupOne().matcher(storyAsText);
        if (findingDescription.matches()) {
            return new Description(findingDescription.group(1).trim());
        }
        return Description.EMPTY;
    }

    protected Meta parseStoryMetaFrom(String storyAsText) {
        Matcher findingMeta = this.patternToPullStoryMetaIntoGroupOne().matcher(this.preScenarioText(storyAsText));
        if (findingMeta.matches()) {
            String meta = findingMeta.group(1).trim();
            return Meta.createMeta((String)meta, (Keywords)this.keywords);
        }
        return Meta.EMPTY;
    }

    protected String preScenarioText(String storyAsText) {
        String[] split = storyAsText.split(this.keywords.scenario());
        return split.length > 0 ? split[0] : storyAsText;
    }

    protected Narrative parseNarrativeFrom(String storyAsText) {
        Matcher findingNarrative = this.patternToPullNarrativeIntoGroupOne().matcher(storyAsText);
        if (findingNarrative.matches()) {
            String narrative = findingNarrative.group(1).trim();
            return this.createNarrative(narrative);
        }
        return Narrative.EMPTY;
    }

    protected Narrative createNarrative(String narrative) {
        Matcher findingElements = this.patternToPullNarrativeElementsIntoGroups().matcher(narrative);
        if (findingElements.matches()) {
            String inOrderTo = findingElements.group(1).trim();
            String asA = findingElements.group(2).trim();
            String iWantTo = findingElements.group(3).trim();
            return new Narrative(inOrderTo, asA, iWantTo);
        }
        Matcher findingAlternativeElements = this.patternToPullAlternativeNarrativeElementsIntoGroups().matcher(narrative);
        if (findingAlternativeElements.matches()) {
            String asA = findingAlternativeElements.group(1).trim();
            String iWantTo = findingAlternativeElements.group(2).trim();
            String soThat = findingAlternativeElements.group(3).trim();
            return new Narrative(NONE, asA, iWantTo, soThat);
        }
        return Narrative.EMPTY;
    }

    protected GivenStories parseGivenStories(String storyAsText) {
        Matcher findingGivenStories;
        String scenarioKeyword = this.keywords.scenario();
        String beforeScenario = NONE;
        if (StringUtils.contains((String)storyAsText, (String)scenarioKeyword)) {
            beforeScenario = StringUtils.substringBefore((String)storyAsText, (String)scenarioKeyword);
        }
        String givenStories = (findingGivenStories = this.patternToPullStoryGivenStoriesIntoGroupOne().matcher(beforeScenario)).find() ? findingGivenStories.group(1).trim() : NONE;
        return new GivenStories(givenStories);
    }

    protected Lifecycle parseLifecycle(String storyAsText) {
        Matcher findingLifecycle;
        String scenarioKeyword = this.keywords.scenario();
        String beforeScenario = NONE;
        if (StringUtils.contains((String)storyAsText, (String)scenarioKeyword)) {
            beforeScenario = StringUtils.substringBefore((String)storyAsText, (String)scenarioKeyword);
        }
        String lifecycle = (findingLifecycle = this.patternToPullLifecycleIntoGroupOne().matcher(beforeScenario)).find() ? findingLifecycle.group(1).trim() : NONE;
        Matcher findingBeforeAndAfter = Pattern.compile(".*" + this.keywords.before() + "(.*)\\s*" + this.keywords.after() + "(.*)\\s*", 32).matcher(lifecycle);
        if (findingBeforeAndAfter.matches()) {
            String beforeLifecycle = findingBeforeAndAfter.group(1).trim();
            Lifecycle.Steps beforeSteps = this.parseBeforeLifecycle(beforeLifecycle);
            String afterLifecycle = findingBeforeAndAfter.group(2).trim();
            Lifecycle.Steps[] afterSteps = this.parseAfterLifecycle(afterLifecycle);
            return new Lifecycle(beforeSteps, afterSteps);
        }
        Matcher findingBefore = Pattern.compile(".*" + this.keywords.before() + "(.*)\\s*", 32).matcher(lifecycle);
        if (findingBefore.matches()) {
            String beforeLifecycle = findingBefore.group(1).trim();
            Lifecycle.Steps beforeSteps = this.parseBeforeLifecycle(beforeLifecycle);
            return new Lifecycle(beforeSteps, new Lifecycle.Steps[]{new Lifecycle.Steps(new ArrayList())});
        }
        Matcher findingAfter = Pattern.compile(".*" + this.keywords.after() + "(.*)\\s*", 32).matcher(lifecycle);
        if (findingAfter.matches()) {
            Lifecycle.Steps beforeSteps = Lifecycle.Steps.EMPTY;
            String afterLifecycle = findingAfter.group(1).trim();
            Lifecycle.Steps[] afterSteps = this.parseAfterLifecycle(afterLifecycle);
            return new Lifecycle(beforeSteps, afterSteps);
        }
        return Lifecycle.EMPTY;
    }

    protected Lifecycle.Steps parseBeforeLifecycle(String lifecycleAsText) {
        return new Lifecycle.Steps(this.findSteps(this.startingWithNL(lifecycleAsText)));
    }

    protected Lifecycle.Steps[] parseAfterLifecycle(String lifecycleAsText) {
        ArrayList<Lifecycle.Steps> list = new ArrayList<Lifecycle.Steps>();
        for (String stepsByOutcome : lifecycleAsText.split(this.keywords.outcome())) {
            if (stepsByOutcome.trim().isEmpty()) continue;
            String outcomeAsText = this.findOutcome(stepsByOutcome);
            List<String> steps = this.findSteps(this.startingWithNL(StringUtils.removeStart((String)stepsByOutcome.trim(), (String)outcomeAsText)));
            list.add(new Lifecycle.Steps(this.parseOutcome(outcomeAsText), steps));
        }
        return list.toArray(new Lifecycle.Steps[list.size()]);
    }

    protected AfterScenario.Outcome parseOutcome(String outcomeAsText) {
        if (outcomeAsText.equals(this.keywords.outcomeSuccess())) {
            return AfterScenario.Outcome.SUCCESS;
        }
        if (outcomeAsText.equals(this.keywords.outcomeFailure())) {
            return AfterScenario.Outcome.FAILURE;
        }
        return AfterScenario.Outcome.ANY;
    }

    protected String findOutcome(String stepsByOutcome) {
        Matcher findingOutcome = this.patternToPullLifecycleOutcomeIntoGroupOne().matcher(stepsByOutcome);
        if (findingOutcome.matches()) {
            return findingOutcome.group(1).trim();
        }
        return this.keywords.outcomeAny();
    }

    protected List<Scenario> parseScenariosFrom(String storyAsText) {
        ArrayList<Scenario> parsed = new ArrayList<Scenario>();
        for (String scenarioAsText : this.splitScenarios(storyAsText)) {
            parsed.add(this.parseScenario(scenarioAsText));
        }
        return parsed;
    }

    protected List<String> splitScenarios(String storyAsText) {
        ArrayList<String> scenarios = new ArrayList<String>();
        String scenarioKeyword = this.keywords.scenario();
        if (StringUtils.contains((String)storyAsText, (String)scenarioKeyword)) {
            storyAsText = StringUtils.substringAfter((String)storyAsText, (String)scenarioKeyword);
        }
        for (String scenarioAsText : storyAsText.split(scenarioKeyword)) {
            if (scenarioAsText.trim().length() <= 0) continue;
            scenarios.add(scenarioKeyword + "\n" + scenarioAsText);
        }
        return scenarios;
    }

    protected Scenario parseScenario(String scenarioAsText) {
        String title = this.findScenarioTitle(scenarioAsText);
        String scenarioWithoutKeyword = StringUtils.removeStart((String)scenarioAsText, (String)this.keywords.scenario()).trim();
        String scenarioWithoutTitle = StringUtils.removeStart((String)scenarioWithoutKeyword, (String)title);
        scenarioWithoutTitle = this.startingWithNL(scenarioWithoutTitle);
        Meta meta = this.findScenarioMeta(scenarioWithoutTitle);
        ExamplesTable examplesTable = this.findExamplesTable(scenarioWithoutTitle);
        GivenStories givenStories = this.findScenarioGivenStories(scenarioWithoutTitle);
        if (givenStories.requireParameters()) {
            givenStories.useExamplesTable(examplesTable);
        }
        List<String> steps = this.findSteps(scenarioWithoutTitle);
        return new Scenario(title, meta, givenStories, examplesTable, steps);
    }

    protected String startingWithNL(String text) {
        if (!text.startsWith("\n")) {
            return "\n" + text;
        }
        return text;
    }

    protected String findScenarioTitle(String scenarioAsText) {
        Matcher findingTitle = this.patternToPullScenarioTitleIntoGroupOne().matcher(scenarioAsText);
        return findingTitle.find() ? findingTitle.group(1).trim() : NONE;
    }

    protected Meta findScenarioMeta(String scenarioAsText) {
        Matcher findingMeta = this.patternToPullScenarioMetaIntoGroupOne().matcher(scenarioAsText);
        if (findingMeta.matches()) {
            String meta = findingMeta.group(1).trim();
            return Meta.createMeta((String)meta, (Keywords)this.keywords);
        }
        return Meta.EMPTY;
    }

    protected ExamplesTable findExamplesTable(String scenarioAsText) {
        Matcher findingTable = this.patternToPullExamplesTableIntoGroupOne().matcher(scenarioAsText);
        String tableInput = findingTable.find() ? findingTable.group(1).trim() : NONE;
        return this.tableFactory.createExamplesTable(tableInput);
    }

    protected GivenStories findScenarioGivenStories(String scenarioAsText) {
        Matcher findingGivenStories = this.patternToPullScenarioGivenStoriesIntoGroupOne().matcher(scenarioAsText);
        String givenStories = findingGivenStories.find() ? findingGivenStories.group(1).trim() : NONE;
        return new GivenStories(givenStories);
    }

    protected List<String> findSteps(String stepsAsText) {
        Matcher matcher = this.patternToPullStepsIntoGroupOne().matcher(stepsAsText);
        ArrayList<String> steps = new ArrayList<String>();
        int startAt = 0;
        while (matcher.find(startAt)) {
            steps.add(StringUtils.substringAfter((String)matcher.group(1), (String)"\n"));
            startAt = matcher.start(4);
        }
        return steps;
    }

    protected Pattern patternToPullDescriptionIntoGroupOne() {
        String metaOrNarrativeOrLifecycleOrScenario = this.concatenateWithOr(this.keywords.meta(), this.keywords.narrative(), this.keywords.lifecycle(), this.keywords.scenario());
        return Pattern.compile("(.*?)(" + metaOrNarrativeOrLifecycleOrScenario + ").*", 32);
    }

    protected Pattern patternToPullStoryMetaIntoGroupOne() {
        String narrativeOrGivenStories = this.concatenateWithOr(this.keywords.narrative(), this.keywords.givenStories());
        return Pattern.compile(".*" + this.keywords.meta() + "(.*?)\\s*(\\Z|" + narrativeOrGivenStories + ").*", 32);
    }

    protected Pattern patternToPullNarrativeIntoGroupOne() {
        String givenStoriesOrLifecycleOrScenario = this.concatenateWithOr(this.keywords.givenStories(), this.keywords.lifecycle(), this.keywords.scenario());
        return Pattern.compile(".*" + this.keywords.narrative() + "(.*?)\\s*(" + givenStoriesOrLifecycleOrScenario + ").*", 32);
    }

    protected Pattern patternToPullNarrativeElementsIntoGroups() {
        return Pattern.compile(".*" + this.keywords.inOrderTo() + "(.*)\\s*" + this.keywords.asA() + "(.*)\\s*" + this.keywords.iWantTo() + "(.*)", 32);
    }

    protected Pattern patternToPullAlternativeNarrativeElementsIntoGroups() {
        return Pattern.compile(".*" + this.keywords.asA() + "(.*)\\s*" + this.keywords.iWantTo() + "(.*)\\s*" + this.keywords.soThat() + "(.*)", 32);
    }

    protected Pattern patternToPullStoryGivenStoriesIntoGroupOne() {
        String lifecycleOrScenario = this.concatenateWithOr(this.keywords.lifecycle(), this.keywords.scenario());
        return Pattern.compile(".*" + this.keywords.givenStories() + "(.*?)\\s*(\\Z|" + lifecycleOrScenario + ").*", 32);
    }

    protected Pattern patternToPullLifecycleIntoGroupOne() {
        return Pattern.compile(".*" + this.keywords.lifecycle() + "\\s*(.*)", 32);
    }

    protected Pattern patternToPullLifecycleOutcomeIntoGroupOne() {
        String startingWords = this.concatenateWithOr("\\n", NONE, this.keywords.startingWords());
        String outcomes = this.concatenateWithOr(this.keywords.outcomeAny(), this.keywords.outcomeSuccess(), this.keywords.outcomeFailure());
        return Pattern.compile("\\s*(" + outcomes + ")\\s*(" + startingWords + ").*", 32);
    }

    protected Pattern patternToPullScenarioTitleIntoGroupOne() {
        String startingWords = this.concatenateWithOr("\\n", NONE, this.keywords.startingWords());
        return Pattern.compile(this.keywords.scenario() + "((.)*?)\\s*(" + this.keywords.meta() + "|" + startingWords + ").*", 32);
    }

    protected Pattern patternToPullScenarioMetaIntoGroupOne() {
        String startingWords = this.concatenateWithOr("\\n", NONE, this.keywords.startingWords());
        return Pattern.compile(".*" + this.keywords.meta() + "(.*?)\\s*(" + this.keywords.givenStories() + "|" + startingWords + ").*", 32);
    }

    protected Pattern patternToPullScenarioGivenStoriesIntoGroupOne() {
        String startingWords = this.concatenateWithOr("\\n", NONE, this.keywords.startingWords());
        return Pattern.compile("\\n" + this.keywords.givenStories() + "((.|\\n)*?)\\s*(" + startingWords + ").*", 32);
    }

    protected Pattern patternToPullStepsIntoGroupOne() {
        Object[] startingWords = this.keywords.startingWords();
        startingWords = (String[])ArrayUtils.removeElement((Object[])startingWords, (Object)this.keywords.ignorable());
        String initialStartingWords = this.concatenateWithOr("\\n", NONE, (String[])startingWords);
        String followingStartingWords = this.concatenateWithOr("\\n", "\\s", (String[])startingWords);
        return Pattern.compile("((" + initialStartingWords + ")\\s(.)*?)\\s*(\\Z|" + followingStartingWords + "|\\n" + this.keywords.examplesTable() + ")", 32);
    }

    protected Pattern patternToPullExamplesTableIntoGroupOne() {
        return Pattern.compile("\\n" + this.keywords.examplesTable() + "\\s*(.*)", 32);
    }

    protected String concatenateWithOr(String ... keywords) {
        return this.concatenateWithOr((String)null, (String)null, keywords);
    }

    protected String concatenateWithOr(String beforeKeyword, String afterKeyword, String[] keywords) {
        StringBuilder builder = new StringBuilder();
        String before = beforeKeyword != null ? beforeKeyword : NONE;
        String after = afterKeyword != null ? afterKeyword : NONE;
        for (String keyword : keywords) {
            builder.append(before).append(keyword).append(after).append("|");
        }
        return StringUtils.chomp((String)builder.toString(), (String)"|");
    }
}

