/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.jbehave.core.reporters;

import com.google.common.base.Strings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbehave.core.model.Meta;
import org.jbehave.core.reporters.NullStoryReporter;
import org.unitils.core.UnitilsException;
import org.unitils.jbehave.modules.JBehaveTestLinkModule;

public class TestLinkJBehaveReporter
extends NullStoryReporter {
    private static final Log LOGGER = LogFactory.getLog(TestLinkJBehaveReporter.class);
    private JBehaveTestLinkModule module = new JBehaveTestLinkModule();
    private Throwable failure;

    public void beforeScenario(String s) {
        this.failure = null;
    }

    public void failed(String s, Throwable throwable) {
        this.failure = throwable.getCause();
    }

    public void scenarioMeta(Meta meta) {
        if (this.module.isEnabled()) {
            this.initializeCaseId(meta.getProperty("TestLinkId"));
            this.initializeSuiteId(meta.getProperty("TestLinkSuiteId"));
        }
    }

    public void afterScenario() {
        if (this.module.isEnabled() && this.module.hasCaseId()) {
            try {
                this.module.updateTestCase(this.failure);
                LOGGER.info((Object)"testlink updated with result");
            }
            catch (UnitilsException e) {
                LOGGER.error((Object)("failed to update testlink: " + e.getMessage()));
            }
        }
        this.module.reset();
    }

    private void initializeSuiteId(String suiteId) {
        if (suiteId == null) {
            suiteId = "";
        }
        this.module.setSuiteId(suiteId);
        LOGGER.info((Object)("testlink suite id " + suiteId + " initialized"));
    }

    private void initializeCaseId(String caseId) {
        if (Strings.isNullOrEmpty((String)caseId)) {
            return;
        }
        this.module.setCaseId(caseId);
        LOGGER.info((Object)("testlink case id " + caseId + " initialized"));
    }
}

