/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.jbehave.core.reporters;

import java.lang.reflect.Field;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.failures.UUIDExceptionWrapper;
import org.jbehave.core.reporters.ConsoleOutput;
import org.jbehave.core.reporters.PrintStreamOutput;
import org.jbehave.core.reporters.StackTraceFormatter;
import org.unitils.util.ReflectionUtils;

public class UnitilsConsoleOutput
extends ConsoleOutput {
    public UnitilsConsoleOutput(Keywords keywords) {
        super(keywords);
    }

    public void failed(String step, Throwable storyFailure) {
        if (!(storyFailure instanceof UUIDExceptionWrapper)) {
            throw new ClassCastException(storyFailure + " should be an instance of UUIDExceptionWrapper");
        }
        String stackTrace = this.createStackTrace(storyFailure);
        this.print(this.format("failed", "{0} ({1})\n({2})\n", new Object[]{step, this.getKeywords().failed(), ((UUIDExceptionWrapper)storyFailure).getUUID()}));
        this.print(stackTrace);
    }

    protected String createStackTrace(Throwable throwable) {
        return new StackTraceFormatter(this.compressFailureTrace()).stackTrace(throwable);
    }

    protected Keywords getKeywords() {
        Field field = ReflectionUtils.getFieldWithName(PrintStreamOutput.class, (String)"keywords", (boolean)false);
        field.setAccessible(true);
        return (Keywords)ReflectionUtils.getFieldValue((Object)((Object)this), (Field)field);
    }
}

