/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.jbehave.core.reporters;

import freemarker.template.Configuration;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbehave.core.reporters.FilePrintStreamFactory;
import org.jbehave.core.reporters.Format;
import org.jbehave.core.reporters.FreemarkerProcessor;
import org.jbehave.core.reporters.StoryReporter;
import org.jbehave.core.reporters.StoryReporterBuilder;
import org.jbehave.core.reporters.TemplateProcessor;
import org.unitils.jbehave.core.reporters.TestLinkJBehaveReporter;
import org.unitils.jbehave.core.reporters.UnitilsConsoleOutput;
import org.unitils.jbehave.core.reporters.UnitilsHtmlReporter;

public abstract class UnitilsFormats {
    private static final Log LOGGER = LogFactory.getLog(UnitilsFormats.class);
    public static final Format TESTLINK = new Format("TESTLINK"){
        private TestLinkJBehaveReporter testLinkReporter = new TestLinkJBehaveReporter();

        public StoryReporter createStoryReporter(FilePrintStreamFactory factory, StoryReporterBuilder storyReporterBuilder) {
            factory.useConfiguration(storyReporterBuilder.fileConfiguration("testlink"));
            return this.testLinkReporter;
        }
    };
    public static final Format CONSOLE = new Format("CONSOLE"){

        public StoryReporter createStoryReporter(FilePrintStreamFactory factory, StoryReporterBuilder storyReporterBuilder) {
            boolean reportFailureTrace = storyReporterBuilder.reportFailureTrace();
            boolean compressFailureTrace = storyReporterBuilder.compressFailureTrace();
            return new UnitilsConsoleOutput(storyReporterBuilder.keywords()).doReportFailureTrace(reportFailureTrace).doCompressFailureTrace(compressFailureTrace);
        }
    };
    public static final Format HTML = new Format("HTML"){

        public StoryReporter createStoryReporter(FilePrintStreamFactory factory, StoryReporterBuilder storyReporterBuilder) {
            factory.useConfiguration(storyReporterBuilder.fileConfiguration("html"));
            Properties viewResources = storyReporterBuilder.viewResources();
            viewResources.setProperty("views", "ftl/unitils-views.ftl");
            viewResources.setProperty("reports", "ftl/unitils-reports-with-totals.ftl");
            viewResources.setProperty("decorated", "ftl/unitils-report-decorated.ftl");
            return new UnitilsHtmlReporter(factory.getOutputFile(), storyReporterBuilder.keywords(), (TemplateProcessor)new MyProcessor(), "ftl/unitils-html-output.ftl");
        }
    };

    protected static class MyProcessor
    extends FreemarkerProcessor {
        protected MyProcessor() {
        }

        public void process(String resource, Map<String, Object> dataModel, Writer writer) {
            Configuration configuration = this.configuration();
            try {
                configuration.setDefaultEncoding("UTF-8");
                configuration.getTemplate(resource).process(dataModel, writer);
            }
            catch (Exception e) {
                LOGGER.error((Object)("Failed to create JBehave report: " + e.getMessage()));
            }
        }
    }
}

