/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.jbehave.core.steps;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.jbehave.core.annotations.AfterScenario;
import org.jbehave.core.steps.BeforeOrAfterStep;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.jbehave.core.steps.StepCollector;
import org.jbehave.core.steps.StepCreator;
import org.unitils.jbehave.core.steps.UnitilsAfterCreateTestObjectStep;
import org.unitils.jbehave.core.steps.UnitilsAfterTestMethodStep;
import org.unitils.jbehave.core.steps.UnitilsAfterTestTearDown;
import org.unitils.jbehave.core.steps.UnitilsBeforeTestClassStep;
import org.unitils.jbehave.core.steps.UnitilsBeforeTestMethod;
import org.unitils.jbehave.core.steps.UnitilsBeforeTestSetUpStep;

public class UnitilsStepsFactory {
    public static List<BeforeOrAfterStep> createBeforeTestClassStep(StepCreator stepCreator, InjectableStepsFactory injectableStepsFactory, Class<?> type) {
        Method testMethod;
        ArrayList<BeforeOrAfterStep> steps = new ArrayList<BeforeOrAfterStep>();
        Method method = testMethod = type.getDeclaredMethods().length > 0 ? type.getDeclaredMethods()[0] : null;
        if (testMethod != null) {
            steps.add(new UnitilsBeforeTestClassStep(testMethod, StepCollector.Stage.BEFORE, type, AfterScenario.Outcome.ANY, stepCreator, injectableStepsFactory));
        }
        return steps;
    }

    public static List<BeforeOrAfterStep> createAfterCreateTestObject(StepCreator stepCreator, InjectableStepsFactory injectableStepsFactory, Class<?> type) {
        Method testMethod;
        ArrayList<BeforeOrAfterStep> steps = new ArrayList<BeforeOrAfterStep>();
        Method method = testMethod = type.getDeclaredMethods().length > 0 ? type.getDeclaredMethods()[0] : null;
        if (testMethod != null) {
            steps.add(new UnitilsAfterCreateTestObjectStep(testMethod, StepCollector.Stage.BEFORE, AfterScenario.Outcome.ANY, stepCreator, injectableStepsFactory, type));
        }
        return steps;
    }

    public static List<BeforeOrAfterStep> createBeforeTestSetUp(StepCreator stepCreator, InjectableStepsFactory injectableStepsFactory, Class<?> type) {
        Method testMethod;
        ArrayList<BeforeOrAfterStep> steps = new ArrayList<BeforeOrAfterStep>();
        Method method = testMethod = type.getDeclaredMethods().length > 0 ? type.getDeclaredMethods()[0] : null;
        if (testMethod != null) {
            steps.add(new UnitilsBeforeTestSetUpStep(testMethod, StepCollector.Stage.BEFORE, AfterScenario.Outcome.ANY, stepCreator, injectableStepsFactory, type));
        }
        return steps;
    }

    public static List<BeforeOrAfterStep> createBeforeTestMethod(StepCreator stepCreator, InjectableStepsFactory stepsFactory, Class<?> type) {
        Method testMethod;
        ArrayList<BeforeOrAfterStep> steps = new ArrayList<BeforeOrAfterStep>();
        Method method = testMethod = type.getDeclaredMethods().length > 0 ? type.getDeclaredMethods()[0] : null;
        if (testMethod != null) {
            steps.add(new UnitilsBeforeTestMethod(testMethod, StepCollector.Stage.BEFORE, AfterScenario.Outcome.ANY, stepCreator, stepsFactory, type));
        }
        return steps;
    }

    public static List<BeforeOrAfterStep> createAfterTestMethod(StepCreator stepCreator, InjectableStepsFactory stepsFactory, Class<?> type) {
        Method testMethod;
        ArrayList<BeforeOrAfterStep> steps = new ArrayList<BeforeOrAfterStep>();
        Method method = testMethod = type.getDeclaredMethods().length > 0 ? type.getDeclaredMethods()[0] : null;
        if (testMethod != null) {
            steps.add(new UnitilsAfterTestMethodStep(testMethod, StepCollector.Stage.AFTER, AfterScenario.Outcome.ANY, stepCreator, stepsFactory, type));
        }
        return steps;
    }

    public static List<BeforeOrAfterStep> createAfterTestTearDown(StepCreator stepCreator, InjectableStepsFactory stepsFactory, Class<?> type) {
        Method testMethod;
        ArrayList<BeforeOrAfterStep> steps = new ArrayList<BeforeOrAfterStep>();
        Method method = testMethod = type.getDeclaredMethods().length > 0 ? type.getDeclaredMethods()[0] : null;
        if (testMethod != null) {
            steps.add(new UnitilsAfterTestTearDown(testMethod, StepCollector.Stage.AFTER, AfterScenario.Outcome.ANY, stepCreator, stepsFactory, type));
        }
        return steps;
    }
}

