package org.unitils.jbehave;

import static org.jbehave.core.io.CodeLocations.codeLocationFromClass;

import java.util.List;

import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.embedder.Embedder;
import org.jbehave.core.io.StoryFinder;
import org.jbehave.core.junit.JUnitStories;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.junit.runner.RunWith;
import org.unitils.jbehave.core.UnitilsInstanceStepsFactory;

import de.codecentric.jbehave.junit.monitoring.JUnitReportingRunner;


/**
 * Extended {@link JUnitStories} with some specific Unitils configuration.
 *
 * @author Willemijn Wouters
 *
 * @since 1.0.0
 *
 */
@RunWith(JUnitReportingRunner.class)
public abstract class UnitilsJUnitStories extends JUnitStories {


    private JBehaveConfiguration config;

    public UnitilsJUnitStories() {
        config = configureJBehave();
    }
    
    public JBehaveConfiguration configureJBehave() {
        return new JBehaveConfiguration();
    }
    
    /**
     * The stepsfactory used by unitils-jbehave.
     *
     * @return {@link InjectableStepsFactory}
     * @see org.jbehave.core.ConfigurableEmbedder#stepsFactory()
     */
    @Override
    public InjectableStepsFactory stepsFactory() {
        return new UnitilsInstanceStepsFactory(configuration(), config.steps());
    }

    @Override
    public Embedder configuredEmbedder() {
        Embedder configuredEmbedder = super.configuredEmbedder();
        
        List<String> configuredMetaFilters = configuredEmbedder.metaFilters();
        configuredMetaFilters.addAll(config.metaFilters());
        configuredEmbedder.useMetaFilters(configuredMetaFilters);
        
        // TODO add these properties in config
        configuredEmbedder
            .embedderControls()
            .doIgnoreFailureInStories(true)
            .doIgnoreFailureInView(true);
        
        return configuredEmbedder;
    }

    @Override
    public List<String> storyPaths() {
        return new StoryFinder().findPaths(codeLocationFromClass(
            this.getClass()), 
            "**/" + config.storyPackage() + "/" + config.storyFile(),
            "");
    }
    
    /**
     * The default configuration used by unitils-jbehave.
     *
     * @return {@link Configuration}
     * @see org.jbehave.core.ConfigurableEmbedder#configuration()
     */
    @Override
    public Configuration configuration() {
        return new JBehaveMostUseFulConfiguration(config).create();
    }
}
