/*
 * Copyright (c) Smals
 */
package org.unitils.jbehave.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;


/**
 * Annotate a test class with MetaFilters to only run the scenarios that match
 * the meta filter.
 * 
 * @author Suzan Rogge
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@Inherited
public @interface MetaFilters {

    String value();
}
