/*
 * Copyright (c) Smals
 */
package org.unitils.jbehave.core.parsers;

import java.util.Map.Entry;
import java.util.Properties;

import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.model.Story;
import org.jbehave.core.parsers.RegexStoryParser;


/**
 * RegexStoryParser that first replaces all variables defined in provided property file.
 * 
 * @author sur
 */
public class RegexIncludingVariablesStoryParser extends RegexStoryParser {

    private Properties variables;
    
    public RegexIncludingVariablesStoryParser(Properties variables) {
        this(variables, new Keywords(Keywords.defaultKeywords()));
    }
    
    /**
     * 
     */
    public RegexIncludingVariablesStoryParser(Properties variables, Keywords keywords) {
        super(keywords);
        if (variables != null) {
            this.variables = variables;
        } else {
            this.variables = new Properties();
        }
    }
    
    @Override
    public Story parseStory(String storyAsText, String storyPath) {
        storyAsText = replaceVariables(storyAsText);
        return super.parseStory(storyAsText, storyPath);
    }
    
    private String replaceVariables(String storyAsText) {
        String modifiedText = storyAsText;
        for (Entry<Object, Object> variable : variables.entrySet()) {
            modifiedText = replaceVariable(modifiedText, (String) variable.getKey(), (String) variable.getValue());
        }
        return modifiedText;
    }
    
    private String replaceVariable(String storyAsText, String key, String value) {
        return storyAsText.replaceAll("\\$\\{" + key + "\\}", value);
    }
}
