/*
 * Copyright (c) Smals
 */
package org.unitils.jbehave.core.reporters;

import java.util.Arrays;
import java.util.List;


/**
 * Strategy as to when the SeleniumScreenshotReporter should take a screenshot.
 */
public enum ScreenshotStrategy {

    /**
     * Only take a screenshot when a step has failed.
     */
    FAILING_ONLY(StepType.AFTER_STEP_FAILED),
    
    /**
     * Take a screenshot for all possible step events:
     *  - before step,
     *  - after step failed.
     */
    ALWAYS(StepType.BEFORE_STEP, StepType.AFTER_STEP_FAILED);
    
    private List<StepType> events;
    
    private ScreenshotStrategy(StepType...events) {
        this.events = Arrays.asList(events);
    }
    
    public boolean shouldTakeScreenshot(StepType event) {
        return events.contains(event);
    }
    
    public enum StepType {
        BEFORE_STEP,
        AFTER_STEP_FAILED;
    }
}
