package org.unitils.jbehave.core.reporters;

import org.jbehave.core.reporters.FilePrintStreamFactory;
import org.jbehave.core.reporters.Format;
import org.jbehave.core.reporters.StoryReporter;
import org.jbehave.core.reporters.StoryReporterBuilder;

/**
 * Unitils custom JBehave Formats for.
 *
 * @author Suzan Rogge
 * @since 31/10/2014
 */
public abstract class UnitilsFormats {


    /**
     * Format for Testlink rapportation.
     */
    public static final Format TESTLINK = new Format("TESTLINK") {

        private TestLinkJBehaveReporter testLinkReporter = new TestLinkJBehaveReporter();

        @Override
        public StoryReporter createStoryReporter(FilePrintStreamFactory factory, StoryReporterBuilder storyReporterBuilder) {
            factory.useConfiguration(storyReporterBuilder.fileConfiguration("testlink"));
            return testLinkReporter;
        }
    };
    
    /**
     * Format for console.
     */
    public static final Format CONSOLE = new Format("CONSOLE") {
        
        @Override
        public StoryReporter createStoryReporter(FilePrintStreamFactory factory, StoryReporterBuilder storyReporterBuilder) {
            boolean reportFailureTrace = storyReporterBuilder.reportFailureTrace();
            boolean compressFailureTrace = storyReporterBuilder.compressFailureTrace();
            return new UnitilsConsoleOutput(storyReporterBuilder.keywords()).doReportFailureTrace(reportFailureTrace).doCompressFailureTrace(compressFailureTrace);
        }
    };

    /**
     * Format for HTML.
     */
    public static final Format HTML = new Format("HTML") {

        @Override
        public StoryReporter createStoryReporter(FilePrintStreamFactory factory, StoryReporterBuilder storyReporterBuilder) {
            factory.useConfiguration(storyReporterBuilder.fileConfiguration("html"));
            return new UnitilsHtmlReporter(factory.getOutputFile(), storyReporterBuilder.keywords());
        }
    };
}
