/*
 * Copyright (c) Smals
 */
package org.unitils.jbehave.core.reporters;

import java.io.Writer;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbehave.core.reporters.FreemarkerProcessor;

import freemarker.template.Configuration;


public class UnitilsFreemarkerProcessor extends FreemarkerProcessor {

    private static final Log LOGGER = LogFactory.getLog(UnitilsFreemarkerProcessor.class);

    @Override
    public void process(String resource, Map<String, Object> dataModel, Writer writer) {
        Configuration configuration = configuration();
        try {
            configuration.setDefaultEncoding("UTF-8");
            configuration.getTemplate(resource).process(dataModel, writer);

        } catch (Exception e) {
            LOGGER.error("Failed to create JBehave report: " + e.getMessage());
        }
    }
}
