package org.unitils.jbehave.core.steps;

import java.lang.reflect.Method;

import org.jbehave.core.annotations.AfterScenario.Outcome;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.jbehave.core.steps.StepCollector.Stage;
import org.jbehave.core.steps.StepCreator;
import org.unitils.core.TestListener;
import org.unitils.util.ReflectionUtils;


/**
 * step for {@link TestListener#beforeTestClass(Class)}.
 *
 * @author Willemijn Wouters
 *
 * @since 1.0.0
 *
 */
public class UnitilsBeforeTestClassStep extends AbstractUnitilsSteps implements IUnitilsStep {

    /**
     * @param testMethod : the test method
     * @param stage : before/after
     * @param outcome : any/success/failure
     * @param stepCreator : a {@link StepCreator}
     * @param injectableStepsFactory : a {@link InjectableStepsFactory}
     * @param type : the type of the step
     */
    public UnitilsBeforeTestClassStep(Method testMethod, Stage stage, Class<?> type, Outcome outcome, StepCreator stepCreator, InjectableStepsFactory injectableStepsFactory) {
        super(stage, ReflectionUtils.getMethod(TestListener.class, "beforeTestClass", false, Class.class), testMethod, outcome, stepCreator, injectableStepsFactory, type);
    }

    /**
     * The parameters needed for the {@link org.unitils.core.TestListener}.
     *
     * @return {@link java.lang.reflect.Array}
     * @see org.unitils.jbehave.core.steps.AbstractUnitilsSteps#getParametersMethod()
     */
    @Override
    protected Object[] getParametersMethod() {
        return new Object[]{
            getClzzStep()
        };
    }


}
