package org.unitils.jbehave.core.steps;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

import org.jbehave.core.annotations.AfterScenario.Outcome;
import org.jbehave.core.steps.BeforeOrAfterStep;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.jbehave.core.steps.StepCollector.Stage;
import org.jbehave.core.steps.StepCreator;


/**
 * This class creates all the Unitils steps.
 *
 * @author Willemijn Wouters
 *
 * @since 1.0.0
 *
 */
public class UnitilsStepsFactory {

    /**
     * Create a list of {@link UnitilsBeforeTestClassStep}.
     *
     * @param stepCreator : a {@link StepCreator}
     * @param injectableStepsFactory : a {@link InjectableStepsFactory}
     * @param type : the type of the step
     * @return {@link List}
     */
    public static List<BeforeOrAfterStep> createBeforeTestClassStep(StepCreator stepCreator, InjectableStepsFactory injectableStepsFactory, Class<?> type) {
        List<BeforeOrAfterStep> steps = new ArrayList<BeforeOrAfterStep>();
        Method testMethod = type.getDeclaredMethods().length > 0 ? type.getDeclaredMethods()[0] : null;
        if (testMethod != null) {
            steps.add(new UnitilsBeforeTestClassStep(testMethod, Stage.BEFORE, type, Outcome.ANY, stepCreator, injectableStepsFactory));
        }
        return steps;
    }

    /**
     * create a list of {@link UnitilsAfterCreateTestObjectStep}
     *
     * @param stepCreator : a {@link StepCreator}
     * @param injectableStepsFactory : a {@link InjectableStepsFactory}
     * @param type : the type of the step
     * @return {@link List}
     */
    public static List<BeforeOrAfterStep> createAfterCreateTestObject(StepCreator stepCreator, InjectableStepsFactory injectableStepsFactory, Class<?> type) {
        List<BeforeOrAfterStep> steps = new ArrayList<BeforeOrAfterStep>();
        Method testMethod = type.getDeclaredMethods().length > 0 ? type.getDeclaredMethods()[0] : null;
        if (testMethod != null) {
            steps.add(new UnitilsAfterCreateTestObjectStep(testMethod, Stage.BEFORE, Outcome.ANY, stepCreator, injectableStepsFactory, type));
        }

        return steps;

    }

    /**
     * create a list of {@link UnitilsBeforeTestSetUpStep}.
     *
     * @param stepCreator : a {@link StepCreator}
     * @param injectableStepsFactory : a {@link InjectableStepsFactory}
     * @param type : the type of the step
     * @return {@link List}
     */
    public static List<BeforeOrAfterStep> createBeforeTestSetUp(StepCreator stepCreator, InjectableStepsFactory injectableStepsFactory, Class<?> type) {
        List<BeforeOrAfterStep> steps = new ArrayList<BeforeOrAfterStep>();
        Method testMethod = type.getDeclaredMethods().length > 0 ? type.getDeclaredMethods()[0] : null;
        if (testMethod != null) {
            steps.add(new UnitilsBeforeTestSetUpStep(testMethod, Stage.BEFORE, Outcome.ANY, stepCreator, injectableStepsFactory, type));
        }

        return steps;
    }

    /**
     * create a list of {@link UnitilsBeforeTestMethod} steps.
     *
     * @param stepCreator : a {@link StepCreator}
     * @param stepsFactory : a {@link InjectableStepsFactory}
     * @param type : the type of the step
     * @return {@link List}
     */
    public static List<BeforeOrAfterStep> createBeforeTestMethod(StepCreator stepCreator, InjectableStepsFactory stepsFactory, Class<?> type) {
        List<BeforeOrAfterStep> steps = new ArrayList<BeforeOrAfterStep>();
        Method testMethod = type.getDeclaredMethods().length > 0 ? type.getDeclaredMethods()[0] : null;
        if (testMethod != null) {
            steps.add(new UnitilsBeforeTestMethod(testMethod, Stage.BEFORE, Outcome.ANY, stepCreator, stepsFactory, type));
        }

        return steps;
    }

    /**
     * create a list of {@link UnitilsAfterTestMethodStep}
     *
     * @param stepCreator : a {@link StepCreator}
     * @param stepsFactory : a {@link InjectableStepsFactory}
     * @param type : the type of the step
     * @return {@link List}
     */
    public static List<BeforeOrAfterStep> createAfterTestMethod(StepCreator stepCreator, InjectableStepsFactory stepsFactory, Class<?> type) {
        List<BeforeOrAfterStep> steps = new ArrayList<BeforeOrAfterStep>();
        Method testMethod = type.getDeclaredMethods().length > 0 ? type.getDeclaredMethods()[0] : null;
        if (testMethod != null) {
            steps.add(new UnitilsAfterTestMethodStep(testMethod, Stage.AFTER, Outcome.ANY, stepCreator, stepsFactory, type));
        }

        return steps;
    }

    /**
     * create a list of {@link UnitilsAfterTestMethodStep}.
     *
     * @param stepCreator : a {@link StepCreator}
     * @param stepsFactory : a {@link InjectableStepsFactory}
     * @param type : the type of the step
     * @return {@link List}
     */
    public static List<BeforeOrAfterStep> createAfterTestTearDown(StepCreator stepCreator, InjectableStepsFactory stepsFactory, Class<?> type) {
        List<BeforeOrAfterStep> steps = new ArrayList<BeforeOrAfterStep>();
        Method testMethod = type.getDeclaredMethods().length > 0 ? type.getDeclaredMethods()[0] : null;
        if (testMethod != null) {
            steps.add(new UnitilsAfterTestTearDown(testMethod, Stage.AFTER, Outcome.ANY, stepCreator, stepsFactory, type));
        }

        return steps;
    }
}
