package org.unitils.jbehave.modules;

import java.lang.reflect.Field;
import java.util.Set;

import org.unitils.core.Unitils;
import org.unitils.core.UnitilsException;
import org.unitils.mail.MailModule;
import org.unitils.mail.annotation.TestSmtpServer;
import org.unitils.mail.impl.SmtpServerImpl;
import org.unitils.util.AnnotationUtils;
import org.unitils.util.PropertyUtils;
import org.unitils.util.ReflectionUtils;


/**
 * You cannot create multiple servers for each test. Jbehave tries to create a server for each {@link org.jbehave.core.steps.Step} and this
 * gives conflicts.
 *
 * @author Willemijn Wouters
 *
 * @since 1.0.0
 *
 */
public class JBehaveMailModule extends MailModule {

    private SmtpServerImpl server;


    /**
     * This method injects the {@link org.subethamail.smtp.server.SMTPServer} into the step.
     *
     * @param testObject : The step.
     * @see org.unitils.mail.MailModule#initSmtpServer(java.lang.Object)
     */
    @Override
    public void initSmtpServer(Object testObject) {
        Set<Field> serverFields = AnnotationUtils.getFieldsAnnotatedWith(testObject.getClass(), TestSmtpServer.class);
        if (!serverFields.isEmpty()) {

            if (serverFields.size() > 1) {
                throw new UnitilsException("Multiple SmtpServer declarations found. Module support only one. ");
            }
            if (server == null || !server.isRunning()) {
                server = new SmtpServerImpl(PropertyUtils.getInt(SMTP_DEFAULT_PORT, 25, Unitils.getInstance().getConfiguration()));
            }

            ReflectionUtils.setFieldValue(testObject, serverFields.iterator().next(), server);
        }
    }

    /**
     * Stops the {@link org.subethamail.smtp.server.SMTPServer}.
     *
     * @param testObject : the step
     *
     * @see org.unitils.mail.MailModule#stopSmtpServer(java.lang.Object)
     */
    @Override
    public void stopSmtpServer(Object testObject) {
        if (server != null && server.isRunning()) {
            server.stop();
        }
    }


    /**
     * getter server.
     *
     * @return {@link SmtpServerImpl}
     */
    protected SmtpServerImpl getServer() {
        return server;
    }


    /**
     * @param server : the server to set
     */
    protected void setServer(SmtpServerImpl server) {
        this.server = server;
    }
}
