package org.unitils.jbehave.modules;


import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;

import javax.sql.DataSource;

import org.unitils.core.Unitils;
import org.unitils.core.UnitilsException;
import org.unitils.core.dbsupport.DefaultSQLHandler;
import org.unitils.database.DatabaseModule;
import org.unitils.dbmaintainer.locator.ClassPathDataLocator;
import org.unitils.dbmaintainer.locator.resourcepickingstrategie.impl.UniqueMostRecentPickingStrategie;
import org.unitils.dbmaintainer.script.impl.DefaultScriptParser;

/**
 * @author sur
 * @since 01/10/2014
 */
public class JBehaveSqlExecutorModule {
    
    private Logger logger = Logger.getLogger(this.getClass().getSimpleName());

    private DataSource dataSource;
    
    public void executeScripts(String[] files) {
        initDataSource();
        try {
            for (String fileName : files) {
                fileName = fileName.trim();
                ClassPathDataLocator dataLocator = new ClassPathDataLocator();
                InputStream inputStream = dataLocator.getDataResource(fileName, new UniqueMostRecentPickingStrategie());
                if (inputStream == null) {
                    throw new UnitilsException("the file path was incorrect no (classpath)file found at " + fileName);
                }
                insertData(inputStream);
                logger.info("executed script " + fileName);
            }
        } catch (SQLException e) {
            throw new UnitilsException(e);
        } catch (IOException e) {
            throw new UnitilsException(e);
        }
    }
    
    private void initDataSource() {
        DatabaseModule databaseModule = Unitils.getInstance().getModulesRepository().getModuleOfType(DatabaseModule.class);
        dataSource = databaseModule.getWrapper("").getDataSource();
    }
    
    protected void insertData(InputStream inputStream) throws SQLException, IOException {
        try {
            DefaultSQLHandler sqlHandler = new DefaultSQLHandler(dataSource);
            DefaultScriptParser parser = new DefaultScriptParser();
            Properties prop = new Properties();
            prop.setProperty("org.unitils.dbmaintainer.script.ScriptParser.backSlashEscapingEnabled", "true");
            parser.init(prop, new InputStreamReader(inputStream, "UTF-8"));
            String stmt = null;
            while ((stmt = parser.getNextStatement()) != null) {
                sqlHandler.executeUpdateAndCommit(stmt);
            }
        } finally {
            dataSource.getConnection().close();
            inputStream.close();
        }
    }
    
}