package org.unitils.jbehave.modules;

import java.util.Properties;

import org.unitils.core.Unitils;
import org.unitils.core.UnitilsException;
import org.unitils.testlink.TestLinkModule;
import org.unitils.util.PropertyUtils;

/**
 * An extention of the {@link TestLinkModule} for JBehave.
 *
 * @author Suzan Rogge
 * @since 31/10/2014
 */
public class JBehaveTestLinkModule extends TestLinkModule {

    private boolean enabled;

    private String projectId;
    private String caseId;

    private String suiteId;

    /**
     * Constructor.
     */
    public JBehaveTestLinkModule() {
        Properties properties = Unitils.getInstance().getConfiguration();
        enabled = PropertyUtils.getBoolean("unitils.module.testlink.enabled", false, properties);
        if (enabled) {
            super.init(properties);
            projectId = PropertyUtils.getString("org.unitils.testlink.projectId", null, properties);
        }
    }

    /**
     * Updates the testcase with the failure from the test.
     *
     * @param failure : the failure thrown by the test.
     * @throws UnitilsException
     */
    public void updateTestCase(Throwable failure) throws UnitilsException {
        super.updateTestCase(caseId, suiteId, failure);
    }

    /**
     * setter caseId.
     *
     * @param caseId : the case ID that you use in Testlink.
     */
    public void setCaseId(String caseId) {
        this.caseId = (projectId == null ? "" : projectId + "-") + caseId;
    }

    /**
     * setter suiteId
     *
     * @param suiteId : The suite ID that you use in Testlink.
     */
    public void setSuiteId(String suiteId) {
        this.suiteId = suiteId;
    }

    /**
     * Check if there is a case ID.
     *
     * @return boolean
     */
    public boolean hasCaseId() {
        return caseId != null;
    }

    /**
     * reset everything.
     */
    public void reset() {
        caseId = null;
        suiteId = null;
    }

    /**
     * getter enabled.
     *
     * @return boolean
     */
    public boolean isEnabled() {
        return enabled;
    }
}
