/*
 * Copyright (c) Smals
 */
package org.unitils.jbehave.steps;


import java.lang.annotation.Annotation;
import java.util.logging.Logger;

import org.jbehave.core.annotations.AfterScenario;
import org.jbehave.core.annotations.AfterScenario.Outcome;
import org.jbehave.core.annotations.BeforeScenario;
import org.jbehave.core.annotations.Named;
import org.unitils.core.Unitils;
import org.unitils.dbunit.DbUnitModule;
import org.unitils.dbunit.annotation.ExpectedDataSet;
import org.unitils.dbunit.datasetfactory.DataSetFactory;
import org.unitils.jbehave.modules.JBehaveSqlExecutorModule;

import com.google.common.base.Strings;

/**
 * @BeforeScenario and @AfterScenario steps for support of @Dataset, @ExpectedDataset and @SqlScript in story files.
 *
 * @author sur
 * @since 01/10/2014
 */
public class DatasetSupportSteps {

    private Logger logger = Logger.getLogger(this.getClass().getSimpleName());
     
    @BeforeScenario
    public void initializeDBUnit(@Named("Dataset") String dbUnitFile, @Named("SqlScript") String sqlScript) {
        executeScript(sqlScript);
        loadDataSet(dbUnitFile);
    }

    private void executeScript(String sqlScript) {
        if (Strings.isNullOrEmpty(sqlScript)) {
            return;
        }
        
        JBehaveSqlExecutorModule module = new JBehaveSqlExecutorModule();
        module.executeScripts(sqlScript.split(","));
    }

    private void loadDataSet(String datasetLocations) {
        if (Strings.isNullOrEmpty(datasetLocations)) {
            return;
        }
        
        String[] datasets = datasetLocations.split(",");
        for (String dataset : datasets) {
            dataset = (dataset.startsWith("/") ? "" : "/") + dataset.trim();

            DbUnitModule module = new DbUnitModule();
            module.init(Unitils.getInstance().getConfiguration());

            module.insertDataSet(this.getClass(), dataset);
            logger.info("dataset loaded : " + dataset);
        }
    }
    
    @AfterScenario(uponOutcome = Outcome.SUCCESS)
    public void assertExpectedDataset(@Named("ExpectedDataset") final String expectedDataset) throws SecurityException, NoSuchMethodException {
        if (!Strings.isNullOrEmpty(expectedDataset)) {
            logger.info("checking expected dataset : " + expectedDataset);
            DbUnitModule module = new DbUnitModule();
            module.init(Unitils.getInstance().getConfiguration());

            ExpectedDataSet expectedDataSet = new ExpectedDataSet() {


                @Override
                public String[] value() {
                    String[] returnDataset = {(expectedDataset.startsWith("/") ? "" : "/") + expectedDataset};
                    return returnDataset;
                }

                @Override
                public Class<? extends Annotation> annotationType() {
                    return null;
                }

                @Override
                public Class<? extends DataSetFactory> factory() {
                    return null;
                }

                @Override
                public String databaseName() {
                    return null;
                }
            };

            module.assertExpectedDataSets(expectedDataSet, this, this.getClass().getMethod("assertExpectedDataset", String.class));
        }
    }
}