/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.jbehave;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.reporters.Format;
import org.jbehave.core.reporters.StoryReporter;
import org.unitils.core.Unitils;
import org.unitils.jbehave.annotations.MetaFilters;
import org.unitils.jbehave.core.reporters.SeleniumScreenshotReporter;
import org.unitils.jbehave.core.reporters.SeleniumSteps;
import org.unitils.jbehave.steps.DatasetSupportSteps;
import org.unitils.util.AnnotationUtils;
import org.unitils.util.PropertyUtils;

public class JBehaveConfiguration {
    private static final String UNITILS_META_FILTERS = "org.unitils.jbehave.meta_filters";
    private List<Object> steps = Lists.newArrayList();
    private List<String> metaFilters = this.initializeMetaFilters();
    private List<StoryReporter> reporters = Lists.newArrayList();
    private List<Format> formats = Lists.newArrayList((Object[])new Format[]{Format.CONSOLE});
    private Map<String, String> keywords = Keywords.defaultKeywords();
    private String storyPackage = "*";
    private String storyFile = "*.story";
    private String screenshotDirectory = "screenshot";

    private List<String> initializeMetaFilters() {
        ArrayList metaFilters = Lists.newArrayList();
        MetaFilters annotationMetaFilters = (MetaFilters)AnnotationUtils.getClassLevelAnnotation(MetaFilters.class, this.getClass());
        if (annotationMetaFilters != null) {
            metaFilters.add(annotationMetaFilters.value());
        } else {
            Properties unitilsProperties = Unitils.getInstance().getConfiguration();
            if (PropertyUtils.containsProperty((String)UNITILS_META_FILTERS, (Properties)unitilsProperties)) {
                metaFilters.add(PropertyUtils.getString((String)UNITILS_META_FILTERS, (Properties)unitilsProperties));
            }
        }
        return metaFilters;
    }

    public JBehaveConfiguration useDatabaseSteps() {
        this.steps.add(new DatasetSupportSteps());
        return this;
    }

    public JBehaveConfiguration addSteps(Object stepsObject) {
        this.steps.add(stepsObject);
        return this;
    }

    public JBehaveConfiguration addStepsWithSeleniumReporter(SeleniumSteps seleniumSteps, String directory) {
        this.steps.add(seleniumSteps);
        this.reporters.add((StoryReporter)new SeleniumScreenshotReporter(directory, seleniumSteps));
        return this;
    }

    public JBehaveConfiguration addStepsWithSeleniumReporter(SeleniumSteps seleniumSteps) {
        return this.addStepsWithSeleniumReporter(seleniumSteps, this.screenshotDirectory);
    }

    public JBehaveConfiguration useDefaultScreenshotDirectory(String screenshotDirectory) {
        this.screenshotDirectory = screenshotDirectory;
        return this;
    }

    public JBehaveConfiguration addStoryReporter(StoryReporter storyReporter) {
        this.reporters.add(storyReporter);
        return this;
    }

    public JBehaveConfiguration addKeywordAlias(String keyword, String alias) {
        this.keywords.put(keyword, this.keywords.get(keyword) + "|" + alias);
        return this;
    }

    public JBehaveConfiguration addMetaFilter(String metaFilter) {
        this.metaFilters.add(metaFilter);
        return this;
    }

    public JBehaveConfiguration useMetaFilters(List<String> metaFilters) {
        this.metaFilters = metaFilters;
        return this;
    }

    public JBehaveConfiguration addFormat(Format format) {
        this.formats.add(format);
        return this;
    }

    public JBehaveConfiguration storyPackage(String storyPackage) {
        this.storyPackage = storyPackage;
        return this;
    }

    public JBehaveConfiguration storyFile(String storyFile) {
        this.storyFile = storyFile;
        return this;
    }

    public List<Object> steps() {
        return this.steps;
    }

    public List<String> metaFilters() {
        return this.metaFilters;
    }

    public StoryReporter[] reporters() {
        return this.reporters.toArray(new StoryReporter[this.reporters.size()]);
    }

    public Format[] formats() {
        return this.formats.toArray(new Format[this.formats.size()]);
    }

    public String storyFile() {
        return this.storyFile;
    }

    public String storyPackage() {
        return this.storyPackage;
    }

    public Keywords keywords() {
        return new Keywords(this.keywords);
    }
}

