/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.jbehave;

import java.io.File;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.configuration.MostUsefulConfiguration;
import org.jbehave.core.failures.FailingUponPendingStep;
import org.jbehave.core.failures.PendingStepStrategy;
import org.jbehave.core.model.StoryMaps;
import org.jbehave.core.parsers.StoryParser;
import org.jbehave.core.reporters.FreemarkerViewGenerator;
import org.jbehave.core.reporters.StoryReporterBuilder;
import org.jbehave.core.reporters.ViewGenerator;
import org.jbehave.core.steps.MarkUnmatchedStepsAsPending;
import org.jbehave.core.steps.StepCollector;
import org.unitils.core.Factory;
import org.unitils.core.util.PropertiesReader;
import org.unitils.jbehave.JBehaveConfiguration;
import org.unitils.jbehave.core.parsers.RegexIncludingVariablesStoryParser;

public class JBehaveMostUseFulConfiguration
implements Factory<Configuration> {
    private Logger logger = Logger.getLogger(this.getClass().getSimpleName());
    private JBehaveConfiguration jbehaveConfiguration;

    public JBehaveMostUseFulConfiguration(JBehaveConfiguration jbehaveConfiguration) {
        this.jbehaveConfiguration = jbehaveConfiguration;
    }

    public Configuration create() {
        MostUsefulConfiguration config = new MostUsefulConfiguration();
        Keywords keywords = this.jbehaveConfiguration.keywords();
        Properties viewResources = new Properties();
        viewResources.setProperty("views", "ftl/unitils-views.ftl");
        viewResources.setProperty("reports", "ftl/unitils-reports-with-totals.ftl");
        viewResources.setProperty("decorated", "ftl/unitils-report-decorated.ftl");
        StoryReporterBuilder storyReporterBuilder = new StoryReporterBuilder().withViewResources(viewResources).withKeywords(keywords).withFormats(this.jbehaveConfiguration.formats()).withReporters(this.jbehaveConfiguration.reporters()).withFailureTrace(true).withMultiThreading(false);
        PropertiesReader propertiesReader = new PropertiesReader();
        Properties jbehaveVariables = propertiesReader.loadPropertiesFileFromClasspath("jbehave.properties");
        return config.useKeywords(keywords).useViewGenerator((ViewGenerator)new NoFailureViewGenerator()).useStoryReporterBuilder(storyReporterBuilder).usePendingStepStrategy((PendingStepStrategy)new FailingUponPendingStep()).useStepCollector((StepCollector)new MarkUnmatchedStepsAsPending(keywords)).useStoryParser((StoryParser)new RegexIncludingVariablesStoryParser(jbehaveVariables, keywords));
    }

    public class NoFailureViewGenerator
    extends FreemarkerViewGenerator {
        public void generateMapsView(File outputDirectory, StoryMaps storyMaps, Properties viewProperties) {
            try {
                super.generateMapsView(outputDirectory, storyMaps, viewProperties);
            }
            catch (Throwable throwable) {
                JBehaveMostUseFulConfiguration.this.logger.warning("failed to generate maps view: " + throwable.getMessage());
            }
        }

        public void generateReportsView(File outputDirectory, List<String> formats, Properties viewProperties) {
            try {
                super.generateReportsView(outputDirectory, formats, viewProperties);
            }
            catch (Throwable throwable) {
                JBehaveMostUseFulConfiguration.this.logger.warning("failed to generate reports view: " + throwable.getMessage());
            }
        }
    }
}

