/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.jbehave.core.parsers;

import java.util.Map;
import java.util.Properties;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.model.Story;
import org.jbehave.core.parsers.RegexStoryParser;

public class RegexIncludingVariablesStoryParser
extends RegexStoryParser {
    private Properties variables;

    public RegexIncludingVariablesStoryParser(Properties variables) {
        this(variables, new Keywords(Keywords.defaultKeywords()));
    }

    public RegexIncludingVariablesStoryParser(Properties variables, Keywords keywords) {
        super(keywords);
        this.variables = variables != null ? variables : new Properties();
    }

    public Story parseStory(String storyAsText, String storyPath) {
        storyAsText = this.replaceVariables(storyAsText);
        return super.parseStory(storyAsText, storyPath);
    }

    private String replaceVariables(String storyAsText) {
        String modifiedText = storyAsText;
        for (Map.Entry<Object, Object> variable : this.variables.entrySet()) {
            modifiedText = this.replaceVariable(modifiedText, (String)variable.getKey(), (String)variable.getValue());
        }
        return modifiedText;
    }

    private String replaceVariable(String storyAsText, String key, String value) {
        return storyAsText.replaceAll("\\$\\{" + key + "\\}", value);
    }
}

