/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.jbehave.core.reporters;

import java.io.File;
import org.jbehave.core.reporters.NullStoryReporter;
import org.unitils.jbehave.core.reporters.ScreenshotStrategy;
import org.unitils.jbehave.core.reporters.SeleniumSteps;
import org.unitils.selenium.ScreenshotTakingWebDriver;

public class SeleniumScreenshotReporter
extends NullStoryReporter {
    private SeleniumSteps steps;
    private String directory;
    private String scenarioTitle;
    private ScreenshotStrategy strategy;

    public SeleniumScreenshotReporter(String directory, SeleniumSteps steps) {
        this(directory, steps, ScreenshotStrategy.FAILING_ONLY);
    }

    public SeleniumScreenshotReporter(String directory, SeleniumSteps steps, ScreenshotStrategy strategy) {
        this.steps = steps;
        this.directory = directory;
        this.strategy = strategy;
    }

    public void beforeScenario(String scenarioTitle) {
        this.scenarioTitle = scenarioTitle;
    }

    public void beforeStep(String step) {
        this.takeScreenshot(step, ScreenshotStrategy.StepType.BEFORE_STEP);
    }

    public void failed(String step, Throwable cause) {
        this.takeScreenshot(step, ScreenshotStrategy.StepType.AFTER_STEP_FAILED);
    }

    private void takeScreenshot(String step, ScreenshotStrategy.StepType stepType) {
        try {
            ScreenshotTakingWebDriver driver = this.steps.getScreenshotTakingWebDriver();
            if (driver != null && this.strategy.shouldTakeScreenshot(stepType)) {
                driver.saveScreenshot(this.getDirectory(), this.getFileName(step));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private File getDirectory() {
        switch (this.strategy) {
            case ALWAYS: {
                return new File("./target/" + this.directory + "/" + this.scenarioTitle.replaceAll(" ", "_"));
            }
        }
        return new File("./target/screenshot/" + this.directory);
    }

    private String getFileName(String step) {
        switch (this.strategy) {
            case ALWAYS: {
                return step.replaceAll(" ", "_");
            }
        }
        return this.scenarioTitle.replaceAll(" ", "_");
    }
}

