/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.jbehave.core.stepcreator;

import com.thoughtworks.paranamer.Paranamer;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.jbehave.core.annotations.AfterScenario;
import org.jbehave.core.annotations.Named;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.failures.BeforeOrAfterFailed;
import org.jbehave.core.failures.UUIDExceptionWrapper;
import org.jbehave.core.model.Meta;
import org.jbehave.core.parsers.StepMatcher;
import org.jbehave.core.steps.AbstractStepResult;
import org.jbehave.core.steps.BeforeOrAfterStep;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.jbehave.core.steps.ParameterControls;
import org.jbehave.core.steps.ParameterConverters;
import org.jbehave.core.steps.Step;
import org.jbehave.core.steps.StepCreator;
import org.jbehave.core.steps.StepMonitor;
import org.jbehave.core.steps.StepResult;
import org.unitils.jbehave.core.steps.IUnitilsStep;
import org.unitils.util.ReflectionUtils;

public class UnitilsStepCreator
extends StepCreator {
    public UnitilsStepCreator(Class<?> stepsType, InjectableStepsFactory stepsFactory, ParameterConverters parameterConverters, ParameterControls parameterControls, StepMatcher stepMatcher, StepMonitor stepMonitor) {
        super(stepsType, stepsFactory, parameterConverters, parameterControls, stepMatcher, stepMonitor);
    }

    public Step createBeforeOrAfterStep(Method method, Meta meta) {
        return new StepCreatorBeforeOrAfterStep(method, meta);
    }

    public Step createAfterStepUponOutcome(Method method, AfterScenario.Outcome outcome, Meta storyAndScenarioMeta) {
        switch (outcome) {
            default: {
                return new StepCreatorBeforeOrAfterStep(method, storyAndScenarioMeta);
            }
            case SUCCESS: {
                return new UnitilsUponSuccessStep(method, storyAndScenarioMeta);
            }
            case FAILURE: 
        }
        return new UnitilsFailureStep(method, storyAndScenarioMeta);
    }

    public Step createAfterStepUponOutcome(Method method, AfterScenario.Outcome outcome, Meta storyAndScenarioMeta, BeforeOrAfterStep step) {
        switch (outcome) {
            default: {
                return new StepCreatorBeforeOrAfterStep(method, storyAndScenarioMeta, step);
            }
            case SUCCESS: {
                return new UnitilsUponSuccessStep(method, storyAndScenarioMeta, step);
            }
            case FAILURE: 
        }
        return new UnitilsFailureStep(method, storyAndScenarioMeta, step);
    }

    protected String[] annotatedParameterNames(Method method) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        String[] names = new String[parameterAnnotations.length];
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            for (Annotation annotation : parameterAnnotations[i]) {
                names[i] = this.annotationName(annotation);
            }
        }
        return names;
    }

    protected String annotationName(Annotation annotation) {
        if (annotation.annotationType().isAssignableFrom(Named.class)) {
            return ((Named)annotation).value();
        }
        if ("javax.inject.Named".equals(annotation.annotationType().getName())) {
            return Jsr330Helper.getNamedValue(annotation);
        }
        return null;
    }

    protected ParameterConverters getParameterConverters() {
        Field field = ReflectionUtils.getFieldWithName(StepCreator.class, (String)"parameterConverters", (boolean)false);
        return (ParameterConverters)ReflectionUtils.getFieldValue((Object)((Object)this), (Field)field);
    }

    protected Paranamer getParanamer() {
        Field fieldParanamer = ReflectionUtils.getFieldWithName(StepCreator.class, (String)"paranamer", (boolean)false);
        return (Paranamer)ReflectionUtils.getFieldValue((Object)((Object)this), (Field)fieldParanamer);
    }

    public static class ParameterName {
        private String name;
        private boolean annotated;

        protected ParameterName(String name, boolean annotated) {
            this.name = name;
            this.annotated = annotated;
        }

        public String getName() {
            return this.name;
        }

        public boolean isAnnotated() {
            return this.annotated;
        }
    }

    protected class MethodInvoker {
        private final Method method;
        private final ParameterConverters parameterConverters;
        private final Paranamer paranamer;
        private final Meta meta;
        private int methodArity;

        public MethodInvoker(Method method, ParameterConverters parameterConverters, Paranamer paranamer, Meta meta) {
            this.method = method;
            this.parameterConverters = parameterConverters;
            this.paranamer = paranamer;
            this.meta = meta;
            this.methodArity = method.getParameterTypes().length;
        }

        public void invoke() throws InvocationTargetException, IllegalAccessException {
            this.method.invoke(UnitilsStepCreator.this.stepsInstance(), this.parameterValuesFrom(this.meta));
        }

        protected Parameter[] methodParameters() {
            Parameter[] parameters = new Parameter[this.methodArity];
            String[] annotationNamedParameters = UnitilsStepCreator.this.annotatedParameterNames(this.method);
            String[] parameterNames = this.paranamer.lookupParameterNames((AccessibleObject)this.method, false);
            Class<?>[] parameterTypes = this.method.getParameterTypes();
            for (int paramPosition = 0; paramPosition < this.methodArity; ++paramPosition) {
                String paramName = this.parameterNameFor(paramPosition, annotationNamedParameters, parameterNames);
                parameters[paramPosition] = new Parameter(paramPosition, parameterTypes[paramPosition], paramName);
            }
            return parameters;
        }

        protected String parameterNameFor(int paramPosition, String[] annotationNamedParameters, String[] parameterNames) {
            String nameFromAnnotation = this.nameIfValidPositionInArray(annotationNamedParameters, paramPosition);
            String parameterName = this.nameIfValidPositionInArray(parameterNames, paramPosition);
            if (nameFromAnnotation != null) {
                return nameFromAnnotation;
            }
            if (parameterName != null) {
                return parameterName;
            }
            return null;
        }

        protected String nameIfValidPositionInArray(String[] paramNames, int paramPosition) {
            return paramPosition < paramNames.length ? paramNames[paramPosition] : null;
        }

        protected Object[] parameterValuesFrom(Meta meta) {
            Object[] values = new Object[this.methodArity];
            for (Parameter parameter : this.methodParameters()) {
                values[((Parameter)parameter).position] = this.parameterConverters.convert(parameter.valueFrom(meta), (Type)parameter.type);
            }
            return values;
        }

        protected class Parameter {
            private final int position;
            private final Class<?> type;
            private final String name;

            public Parameter(int position, Class<?> type, String name) {
                this.position = position;
                this.type = type;
                this.name = name;
            }

            public String valueFrom(Meta meta) {
                if (this.name == null) {
                    return null;
                }
                return meta.getProperty(this.name);
            }
        }
    }

    public class StepCreatorBeforeOrAfterStep
    extends StepCreator.AbstractStep {
        private final Method method;
        private final Meta meta;
        private IUnitilsStep unitilsStep;

        public StepCreatorBeforeOrAfterStep(Method method, Meta meta) {
            this.method = method;
            this.meta = meta;
        }

        public StepCreatorBeforeOrAfterStep(Method method, Meta meta, BeforeOrAfterStep step) {
            this(method, meta);
            if (step instanceof IUnitilsStep) {
                this.unitilsStep = (IUnitilsStep)step;
            }
        }

        public StepResult perform(UUIDExceptionWrapper storyFailureIfItHappened) {
            ParameterConverters paramConvertersWithExceptionInjector = this.paramConvertersWithExceptionInjector(storyFailureIfItHappened);
            MethodInvoker methodInvoker = new MethodInvoker(this.method, paramConvertersWithExceptionInjector, UnitilsStepCreator.this.getParanamer(), this.meta);
            try {
                if (this.unitilsStep != null) {
                    this.unitilsStep.invokeUnitilsMethod();
                } else {
                    methodInvoker.invoke();
                }
            }
            catch (InvocationTargetException e) {
                return AbstractStepResult.failed((Method)this.method, (UUIDExceptionWrapper)new UUIDExceptionWrapper((Throwable)new BeforeOrAfterFailed(this.method, e.getCause())));
            }
            catch (Throwable t) {
                return AbstractStepResult.failed((Method)this.method, (UUIDExceptionWrapper)new UUIDExceptionWrapper((Throwable)new BeforeOrAfterFailed(this.method, t)));
            }
            return AbstractStepResult.skipped();
        }

        protected ParameterConverters paramConvertersWithExceptionInjector(UUIDExceptionWrapper storyFailureIfItHappened) {
            return UnitilsStepCreator.this.getParameterConverters().newInstanceAdding((ParameterConverters.ParameterConverter)new UUIDExceptionWrapperInjector(storyFailureIfItHappened));
        }

        public StepResult doNotPerform(UUIDExceptionWrapper storyFailureIfItHappened) {
            return this.perform(storyFailureIfItHappened);
        }

        public Meta getMeta() {
            return this.meta;
        }

        public Method getMethod() {
            return this.method;
        }

        public class UUIDExceptionWrapperInjector
        implements ParameterConverters.ParameterConverter {
            private final UUIDExceptionWrapper storyFailureIfItHappened;

            public UUIDExceptionWrapperInjector(UUIDExceptionWrapper storyFailureIfItHappened) {
                this.storyFailureIfItHappened = storyFailureIfItHappened;
            }

            public boolean accept(Type type) {
                return UUIDExceptionWrapper.class == type;
            }

            public Object convertValue(String value, Type type) {
                return this.storyFailureIfItHappened;
            }
        }
    }

    public static class Jsr330Helper {
        public static String getNamedValue(Annotation annotation) {
            return ((Named)annotation).value();
        }
    }

    protected class UnitilsUponSuccessStep
    extends StepCreator.UponSuccessStep {
        private StepCreatorBeforeOrAfterStep beforeOrAfterStep;

        public UnitilsUponSuccessStep(Method method, Meta storyAndScenarioMeta, BeforeOrAfterStep step) {
            super((StepCreator)UnitilsStepCreator.this, method, storyAndScenarioMeta);
            this.beforeOrAfterStep = new StepCreatorBeforeOrAfterStep(method, storyAndScenarioMeta, step);
        }

        public UnitilsUponSuccessStep(Method method, Meta storyAndScenarioMeta) {
            super((StepCreator)UnitilsStepCreator.this, method, storyAndScenarioMeta);
            this.beforeOrAfterStep = new StepCreatorBeforeOrAfterStep(method, storyAndScenarioMeta);
        }

        public StepResult doNotPerform(UUIDExceptionWrapper storyFailureIfItHappened) {
            return AbstractStepResult.skipped();
        }

        public StepResult perform(UUIDExceptionWrapper storyFailureIfItHappened) {
            return this.beforeOrAfterStep.perform(storyFailureIfItHappened);
        }

        public String asString(Keywords keywords) {
            return this.beforeOrAfterStep.asString(keywords);
        }
    }

    protected class UnitilsFailureStep
    extends StepCreator.UponFailureStep {
        private StepCreatorBeforeOrAfterStep beforeOrAfterStep;

        public UnitilsFailureStep(Method method, Meta storyAndScenarioMeta, BeforeOrAfterStep beforeOrAfterStep) {
            super((StepCreator)UnitilsStepCreator.this, method, storyAndScenarioMeta);
            this.beforeOrAfterStep = new StepCreatorBeforeOrAfterStep(method, storyAndScenarioMeta, beforeOrAfterStep);
        }

        public UnitilsFailureStep(Method method, Meta storyAndScenarioMeta) {
            super((StepCreator)UnitilsStepCreator.this, method, storyAndScenarioMeta);
            this.beforeOrAfterStep = new StepCreatorBeforeOrAfterStep(method, storyAndScenarioMeta);
        }

        public StepResult doNotPerform(UUIDExceptionWrapper storyFailureIfItHappened) {
            return this.beforeOrAfterStep.perform(storyFailureIfItHappened);
        }

        public StepResult perform(UUIDExceptionWrapper storyFailureIfItHappened) {
            return AbstractStepResult.skipped();
        }

        public String asString(Keywords keywords) {
            return this.beforeOrAfterStep.asString(keywords);
        }
    }
}

