/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.jbehave.modules;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.unitils.core.Unitils;
import org.unitils.core.UnitilsException;
import org.unitils.core.dbsupport.DefaultSQLHandler;
import org.unitils.database.DatabaseModule;
import org.unitils.dbmaintainer.locator.ClassPathDataLocator;
import org.unitils.dbmaintainer.locator.resourcepickingstrategie.ResourcePickingStrategie;
import org.unitils.dbmaintainer.locator.resourcepickingstrategie.impl.UniqueMostRecentPickingStrategie;
import org.unitils.dbmaintainer.script.impl.DefaultScriptParser;

public class JBehaveSqlExecutorModule {
    private Logger logger = Logger.getLogger(this.getClass().getSimpleName());
    private DataSource dataSource;

    public void executeScripts(String[] files) {
        this.initDataSource();
        try {
            for (String fileName : files) {
                ClassPathDataLocator dataLocator = new ClassPathDataLocator();
                InputStream inputStream = dataLocator.getDataResource(fileName = fileName.trim(), (ResourcePickingStrategie)new UniqueMostRecentPickingStrategie());
                if (inputStream == null) {
                    throw new UnitilsException("the file path was incorrect no (classpath)file found at " + fileName);
                }
                this.insertData(inputStream);
                this.logger.info("executed script " + fileName);
            }
        }
        catch (SQLException e) {
            throw new UnitilsException((Throwable)e);
        }
        catch (IOException e) {
            throw new UnitilsException((Throwable)e);
        }
    }

    private void initDataSource() {
        DatabaseModule databaseModule = (DatabaseModule)Unitils.getInstance().getModulesRepository().getModuleOfType(DatabaseModule.class);
        this.dataSource = databaseModule.getWrapper("").getDataSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertData(InputStream inputStream) throws SQLException, IOException {
        try {
            DefaultSQLHandler sqlHandler = new DefaultSQLHandler(this.dataSource);
            DefaultScriptParser parser = new DefaultScriptParser();
            Properties prop = new Properties();
            prop.setProperty("org.unitils.dbmaintainer.script.ScriptParser.backSlashEscapingEnabled", "true");
            parser.init(prop, (Reader)new InputStreamReader(inputStream, "UTF-8"));
            String stmt = null;
            while ((stmt = parser.getNextStatement()) != null) {
                sqlHandler.executeUpdateAndCommit(stmt);
            }
        }
        finally {
            this.dataSource.getConnection().close();
            inputStream.close();
        }
    }
}

