/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.jbehave.steps;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.util.logging.Logger;
import org.jbehave.core.annotations.AfterScenario;
import org.jbehave.core.annotations.BeforeScenario;
import org.jbehave.core.annotations.Named;
import org.unitils.core.Unitils;
import org.unitils.dbunit.DbUnitModule;
import org.unitils.dbunit.annotation.ExpectedDataSet;
import org.unitils.dbunit.datasetfactory.DataSetFactory;
import org.unitils.jbehave.modules.JBehaveSqlExecutorModule;

public class DatasetSupportSteps {
    private Logger logger = Logger.getLogger(this.getClass().getSimpleName());

    @BeforeScenario
    public void initializeDBUnit(@Named(value="Dataset") String dbUnitFile, @Named(value="SqlScript") String sqlScript) {
        this.executeScript(sqlScript);
        this.loadDataSet(dbUnitFile);
    }

    private void executeScript(String sqlScript) {
        if (Strings.isNullOrEmpty((String)sqlScript)) {
            return;
        }
        JBehaveSqlExecutorModule module = new JBehaveSqlExecutorModule();
        module.executeScripts(sqlScript.split(","));
    }

    private void loadDataSet(String datasetLocations) {
        String[] datasets;
        if (Strings.isNullOrEmpty((String)datasetLocations)) {
            return;
        }
        for (String dataset : datasets = datasetLocations.split(",")) {
            dataset = (dataset.startsWith("/") ? "" : "/") + dataset.trim();
            DbUnitModule module = new DbUnitModule();
            module.init(Unitils.getInstance().getConfiguration());
            module.insertDataSet(this.getClass(), new String[]{dataset});
            this.logger.info("dataset loaded : " + dataset);
        }
    }

    @AfterScenario(uponOutcome=AfterScenario.Outcome.SUCCESS)
    public void assertExpectedDataset(final @Named(value="ExpectedDataset") String expectedDataset) throws SecurityException, NoSuchMethodException {
        if (!Strings.isNullOrEmpty((String)expectedDataset)) {
            this.logger.info("checking expected dataset : " + expectedDataset);
            DbUnitModule module = new DbUnitModule();
            module.init(Unitils.getInstance().getConfiguration());
            ExpectedDataSet expectedDataSet = new ExpectedDataSet(){

                public String[] value() {
                    String[] returnDataset = new String[]{(expectedDataset.startsWith("/") ? "" : "/") + expectedDataset};
                    return returnDataset;
                }

                public Class<? extends Annotation> annotationType() {
                    return null;
                }

                public Class<? extends DataSetFactory> factory() {
                    return null;
                }

                public String databaseName() {
                    return null;
                }
            };
            module.assertExpectedDataSets(expectedDataSet, (Object)this, this.getClass().getMethod("assertExpectedDataset", String.class));
        }
    }
}

