<#ftl strip_whitespace=true>
<#macro renderStat stats name class=""><#assign value = stats.get(name)!0><#if (value != 0)><span
        class="${class}">${value}</span><#else>${value}</#if></#macro>
<#macro renderTime millis class=""><span
        class="${class}"><#assign time = timeFormatter.formatMillis(millis)>${time}</span></#macro>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
        "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
    <title>JBehave Reports</title>
    <meta http-equiv="Content-Type" content="text/html; charset=${encoding!'UTF-8'}"/>
    <style type="text/css" media="all">
        <#include "css/jbehave-core.css" parse="false">
    </style>
</head>

<body>

<div class="reports">

    <h2>Story Reports</h2>

    <table>
        <colgroup span="2" class="stories"></colgroup>
        <colgroup span="5" class="scenarios"></colgroup>
        <colgroup span="5" class="scenarios"></colgroup>
        <colgroup span="6" class="steps"></colgroup>
        <colgroup class="view"></colgroup>
        <tr>
            <th colspan="2">Stories</th>
            <th colspan="5">Scenarios</th>
        </tr>
        <tr>
            <th>Name</th>
            <th>Total</th>
            <th>Successful</th>
            <th>Pending</th>
            <th>Failed</th>
            <th>Excluded</th>
            <th>Duration</th>
        </tr>
    <#assign reportNames = reportsTable.getReportNames()>
    <#assign totalReports = reportNames.size() - 3>
    <#list reportNames as name>
        <#assign report = reportsTable.getReport(name)>
        <#if name != "Totals" && name != "AfterStories" && name != "BeforeStories">
            <tr>
                <#assign stats = report.getStats()>
                <#assign scenariosFailed = stats.get("scenariosFailed")!0>
                <#assign pending = stats.get("pending")!0>
                <#assign storyClass = "story">
                <#if scenariosFailed != 0>

                    <#assign storyClass = storyClass + " failed">
                <#elseif pending != 0>
                    <#assign storyClass = storyClass + " pending">
                <#else>
                    <#assign storyClass = storyClass + " successful">
                </#if>
                <td class="${storyClass}">
                    <#assign filesByFormat = report.filesByFormat>
                    <#assign file = filesByFormat.get('html')>
                    <a href="${(file.name!'')}">${report.name}</a> 
                </td>
                <td>
                    <@renderStat stats "scenarios"/>
                </td>
                <td>
                    <@renderStat stats "scenariosSuccessful" "successful"/>
                </td>
                <td>
                    <@renderStat stats "scenariosPending" "pending"/>
                </td>
                <td>
                    <@renderStat stats "scenariosFailed" "failed"/>
                </td>
                <td>
                    <@renderStat stats "scenariosNotAllowed" "failed"/>
                </td>
                <td>
                    <#assign path = report.getPath()>
<@renderTime (storyDurations.get(path))!0/>
                </td>
            <#--<td>
            <#list filesByFormat.keySet() as format><#assign file = filesByFormat.get(format)><a href="${file.name}">${format}</a><#if format_has_next> |</#if></#list>
            </td>-->
            </tr>
        </#if>
    </#list>
        <tr class="totals">
            <td>${totalReports}</td>
        <#assign stats = reportsTable.getReport("Totals").getStats()>
            <td>
            <@renderStat stats "scenarios"/>
            </td>
            <td>
            <@renderStat stats "scenariosSuccessful" "successful"/>
            </td>
            <td>
            <@renderStat stats "scenariosPending" "pending"/>
            </td>
            <td>
            <@renderStat stats "scenariosFailed" "failed"/>
            </td>
            <td>
            <@renderStat stats "scenariosNotAllowed" "failed"/>
            </td>
            <td>
            <@renderTime (storyDurations.get('total'))!0/>
            </td>
        </tr>
    </table>
    <br/>
</div>

<div class="clear"></div>
<div id="footer">
    <div class="left">Generated on ${date?string("dd/MM/yyyy HH:mm:ss")}</div>
    <div class="right">JBehave &#169; 2003-2014</div>
    <div class="clear"></div>
</div>

</body>

</html>
