package org.unitils.jodatime.annotation;

import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Sets the {@link DateTime} to a fixed value. Basicly the {@link DateTime} in millis will be constant. The default fixed datetime is the
 * current datetime. The default pattern is 'dd/MM/yyyy'.
 * 
 * @author Christophe De Blende
 * @author Jeroen Horemans
 * @author Thomas De Rycke
 * @author Willemijn Wouters
 * 
 * @since 1.0.0
 *  
 */
@Target({
    ElementType.METHOD, ElementType.TYPE
})
@Retention(RUNTIME)
public @interface FixedDateTime {

    /**
     * @return text value of the fixed {@link DateTime}.
     */
    String datetime() default "";

    /**
     * @return pattern value used to parse the datetime value. The default pattern is 'dd/MM/yyyy'.
     */
    String pattern() default "dd/MM/yyyy";
}
