package org.unitils.jodatime.annotation;

import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Sets the {@link DateTime} to an offset relative to the current system time. Basicly the {@link DateTime} in millis will be
 * System.currentTimeMillis() + offset.
 * 
 * The offset is calculated as a {@link Period} in years, months, days, hours, minutes, seconds, weeks and millis. Which means the user
 * doesn't have to calculate the offset for a given year, but can just set the years value to -1 to go back one year in time.
 * 
 * @author Christophe De Blende
 * @author Jeroen Horemans
 * @author Thomas De Rycke
 * @author Willemijn Wouters
 * 
 * @since 1.0.0
 * 
 */
@Target({
    ElementType.METHOD, ElementType.TYPE
})
@Retention(RUNTIME)
public @interface OffsetDateTime {

    /**
     * @return offset in years.
     */
    int years() default 0;

    /**
     * @return offset in months.
     */
    int months() default 0;

    /**
     * @return offset in days.
     */
    int days() default 0;

    /**
     * @return offset in hours.
     */
    int hours() default 0;

    /**
     * @return offset in minutes.
     */
    int minutes() default 0;

    /**
     * @return offset in seconds.
     */
    int seconds() default 0;

    /**
     * @return offset in weeks.
     */
    int weeks() default 0;

    /**
     * @return offset in millis.
     */
    int millis() default 0;
}
