/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.jodatime;

import java.lang.reflect.Method;
import java.util.Properties;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.Duration;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.DateTimeFormat;
import org.unitils.core.Module;
import org.unitils.core.TestListener;
import org.unitils.jodatime.annotation.FixedDateTime;
import org.unitils.jodatime.annotation.OffsetDateTime;

public class JodaTimeModule
implements Module {
    public void init(Properties configuration) {
    }

    public void afterInit() {
    }

    public TestListener getTestListener() {
        return new DateTimeModuleListener();
    }

    protected static class DateTimeModuleListener
    extends TestListener {
        private long fixedMillis;
        private long offsetMillis;

        protected DateTimeModuleListener() {
        }

        public void afterTestTearDown(Object testObject, Method testMethod) {
            DateTimeUtils.setCurrentMillisSystem();
        }

        public void beforeTestClass(Class<?> testClass) {
            this.fixedMillis = 0L;
            this.offsetMillis = 0L;
            if (testClass.isAnnotationPresent(FixedDateTime.class)) {
                FixedDateTime fixedDateTime = testClass.getAnnotation(FixedDateTime.class);
                this.fixedMillis = this.calculateFixedMillis(fixedDateTime);
                DateTimeUtils.setCurrentMillisFixed((long)this.fixedMillis);
            } else if (testClass.isAnnotationPresent(OffsetDateTime.class)) {
                OffsetDateTime offsetDateTime = testClass.getAnnotation(OffsetDateTime.class);
                this.offsetMillis = this.calculateOffsetMillis(offsetDateTime);
                DateTimeUtils.setCurrentMillisOffset((long)this.offsetMillis);
            } else {
                DateTimeUtils.setCurrentMillisSystem();
            }
        }

        public void beforeTestSetUp(Object testObject, Method testMethod) {
            if (testMethod.isAnnotationPresent(FixedDateTime.class)) {
                FixedDateTime fixedDateTime = testMethod.getAnnotation(FixedDateTime.class);
                DateTimeUtils.setCurrentMillisFixed((long)this.calculateFixedMillis(fixedDateTime));
            } else if (testMethod.isAnnotationPresent(OffsetDateTime.class)) {
                OffsetDateTime offsetDateTime = testMethod.getAnnotation(OffsetDateTime.class);
                DateTimeUtils.setCurrentMillisOffset((long)this.calculateOffsetMillis(offsetDateTime));
            } else if (this.fixedMillis != 0L) {
                DateTimeUtils.setCurrentMillisFixed((long)this.fixedMillis);
            } else if (this.offsetMillis != 0L) {
                DateTimeUtils.setCurrentMillisOffset((long)this.offsetMillis);
            } else {
                DateTimeUtils.setCurrentMillisSystem();
            }
        }

        private long calculateFixedMillis(FixedDateTime fixedDateTime) {
            if (fixedDateTime.datetime() == null || fixedDateTime.datetime().length() == 0) {
                return new DateTime().getMillis();
            }
            DateTime dateTime = DateTimeFormat.forPattern((String)fixedDateTime.pattern()).parseDateTime(fixedDateTime.datetime());
            return dateTime.getMillis();
        }

        private long calculateOffsetMillis(OffsetDateTime offsetDateTime) {
            Period period = new Period(offsetDateTime.years(), offsetDateTime.months(), offsetDateTime.weeks(), offsetDateTime.days(), offsetDateTime.hours(), offsetDateTime.minutes(), offsetDateTime.seconds(), offsetDateTime.millis());
            DateTime currentDate = new DateTime();
            DateTime offisetDate = currentDate.plus((ReadablePeriod)period);
            Duration duration = new Duration((ReadableInstant)currentDate, (ReadableInstant)offisetDate);
            return duration.getMillis();
        }
    }
}

